/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.components;

import com.archimatetool.editor.preferences.ColoursPreferencePage;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.CustomColorDialog;
import com.archimatetool.editor.ui.components.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ColorChooser
extends EventManager {
    public static final String PROP_COLORCHANGE = "colorValue";
    public static final String PROP_COLORDEFAULT = "colorDefault";
    private Composite fComposite;
    private Button fColorButton;
    private Button fMenuButton;
    private RGB fColorValue;
    private boolean fIsDefaultColor;
    protected boolean fDoShowDefaultMenuItem = true;
    protected boolean fDoShowPreferencesMenuItem = true;
    protected boolean fDoShowColorImage = true;
    private List<IAction> fExtraActionsList = new ArrayList<IAction>();

    public ColorChooser(Composite parent, FormToolkit toolkit) {
        this(parent);
        toolkit.adapt((Control)this.fColorButton, true, true);
        toolkit.adapt((Control)this.fMenuButton, true, true);
    }

    public ColorChooser(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setBackgroundMode(2);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.fComposite.setLayout((Layout)layout);
        this.fColorButton = new Button(this.fComposite, 0x800000);
        GridDataFactory.create((int)0).hint(60, -1).applyTo((Control)this.fColorButton);
        this.fColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorChooser.this.chooseColor();
            }
        });
        this.fColorButton.addDisposeListener(e -> {
            if (this.fColorButton.getImage() != null) {
                this.fColorButton.getImage().dispose();
            }
        });
        this.fComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Colour Chooser";
            }
        });
        this.fMenuButton = new Button(this.fComposite, 0x800000);
        this.fMenuButton.setLayoutData((Object)new GridData(1040));
        this.fMenuButton.setImage(IArchiImages.ImageFactory.getImage("img/menu-arrow.png"));
        this.fMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorChooser.this.showMenu();
            }
        });
    }

    public void setIsDefaultColor(boolean set) {
        this.fIsDefaultColor = set;
    }

    public boolean isDefaultColor() {
        return this.fIsDefaultColor;
    }

    public void setDoShowPreferencesMenuItem(boolean set) {
        this.fDoShowPreferencesMenuItem = set;
    }

    public void setDoShowDefaultMenuItem(boolean set) {
        this.fDoShowDefaultMenuItem = set;
    }

    public void setDoShowColorImage(boolean set) {
        this.fDoShowColorImage = set;
        this.updateColorImage();
    }

    public Control getControl() {
        return this.fComposite;
    }

    public Button getColorButton() {
        return this.fColorButton;
    }

    public void showMenu() {
        MenuManager menuManager = new MenuManager();
        this.addMenuActions(menuManager);
        Menu menu = menuManager.createContextMenu((Control)this.fMenuButton.getShell());
        Point p = this.fColorButton.getParent().toDisplay(this.fMenuButton.getBounds().x, this.fMenuButton.getBounds().y);
        menu.setLocation(p);
        menu.setVisible(true);
    }

    public void addMenuAction(IAction action) {
        if (action != null && !this.fExtraActionsList.contains(action)) {
            this.fExtraActionsList.add(action);
        }
    }

    protected void addMenuActions(MenuManager menuManager) {
        if (this.fDoShowDefaultMenuItem) {
            Action defaultColorAction = new Action(Messages.ColorChooser_1){

                public void run() {
                    boolean oldValue = ColorChooser.this.fIsDefaultColor;
                    ColorChooser.this.fIsDefaultColor = !ColorChooser.this.fIsDefaultColor;
                    ColorChooser.this.fireActionListenerEvent(ColorChooser.PROP_COLORDEFAULT, oldValue, ColorChooser.this.fIsDefaultColor);
                }
            };
            menuManager.add((IAction)defaultColorAction);
            defaultColorAction.setEnabled(!this.isDefaultColor());
        }
        for (IAction action : this.fExtraActionsList) {
            menuManager.add(action);
        }
        if (this.fDoShowPreferencesMenuItem) {
            menuManager.add((IContributionItem)new Separator());
            Action preferencesAction = new Action(Messages.ColorChooser_2){

                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)ColorChooser.this.getControl().getShell(), (String)ColoursPreferencePage.ID, null, null);
                    if (dialog != null) {
                        dialog.open();
                    }
                }
            };
            menuManager.add((IAction)preferencesAction);
        }
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void setColorValue(RGB rgb) {
        if (rgb != null && !rgb.equals((Object)this.fColorValue)) {
            this.fColorValue = rgb;
            this.updateColorImage();
        }
    }

    public void setEnabled(boolean state) {
        this.getControl().setEnabled(state);
        this.fColorButton.setEnabled(state);
        this.fMenuButton.setEnabled(state);
    }

    public void chooseColor() {
        CustomColorDialog colorDialog = new CustomColorDialog(this.fColorButton.getShell());
        colorDialog.setRGB(this.fColorValue);
        RGB newColor = colorDialog.open();
        if (newColor != null && !newColor.equals((Object)this.fColorValue)) {
            RGB oldValue = this.fColorValue;
            this.fColorValue = newColor;
            this.fireActionListenerEvent(PROP_COLORCHANGE, oldValue, newColor);
            this.updateColorImage();
        }
    }

    protected void updateColorImage() {
        Image image = new Image((Device)this.fColorButton.getDisplay(), zoom -> {
            Image tmp = new Image((Device)this.fColorButton.getDisplay(), 40, 15);
            GC gc = new GC((Drawable)tmp);
            gc.setBackground(this.fDoShowColorImage ? new Color(this.fColorValue) : new Color(255, 255, 255));
            gc.fillRectangle(0, 0, 39, 14);
            gc.drawRectangle(0, 0, 39, 14);
            if (!this.fDoShowColorImage) {
                gc.drawLine(0, 1, 39, 13);
            }
            gc.dispose();
            ImageData imageData = tmp.getImageData(zoom);
            tmp.dispose();
            return imageData;
        });
        Image oldImage = this.fColorButton.getImage();
        this.fColorButton.setImage(image);
        if (oldImage != null) {
            oldImage.dispose();
        }
    }

    public void addListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public void removeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    private void fireActionListenerEvent(String propertyName, Object oldValue, Object newValue) {
        Object[] finalListeners = this.getListeners();
        if (finalListeners.length > 0) {
            PropertyChangeEvent pEvent = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
            int i = 0;
            while (i < finalListeners.length) {
                IPropertyChangeListener listener = (IPropertyChangeListener)finalListeners[i];
                listener.propertyChange(pEvent);
                ++i;
            }
        }
    }
}

