/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.components;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CompositeMultiImageDescriptor
extends CompositeImageDescriptor {
    private ImageDescriptor[] fOverlays;
    private Point fSize;

    public CompositeMultiImageDescriptor(ImageDescriptor[] overlays) {
        this.fOverlays = overlays;
    }

    public CompositeMultiImageDescriptor(ImageDescriptor[] overlays, Point size) {
        this.fSize = size;
        this.fOverlays = overlays;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor[] imageDescriptorArray = this.fOverlays;
        int n = this.fOverlays.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor overlay = imageDescriptorArray[n2];
            if (overlay != null) {
                this.drawImage(zoom -> overlay.getImageData(100), 0, 0);
            }
            ++n2;
        }
    }

    protected Point getSize() {
        if (this.fSize == null) {
            this.fSize = new Point(1, 1);
            ImageDescriptor[] imageDescriptorArray = this.fOverlays;
            int n = this.fOverlays.length;
            int n2 = 0;
            while (n2 < n) {
                ImageDescriptor overlay = imageDescriptorArray[n2];
                if (overlay != null) {
                    ImageData id = overlay.getImageData(100);
                    this.fSize.x = Math.max(this.fSize.x, id.width);
                    this.fSize.y = Math.max(this.fSize.y, id.height);
                }
                ++n2;
            }
        }
        return this.fSize;
    }
}

