/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.components;

import com.archimatetool.editor.actions.ArchiActionFactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class GlobalActionDisablementHandler {
    private static final String[] actionIds = new String[]{ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ArchiActionFactory.PASTE_SPECIAL.getId(), ActionFactory.DELETE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.FIND.getId(), ActionFactory.RENAME.getId(), ActionFactory.UNDO.getId(), ActionFactory.REDO.getId()};
    private Map<String, IAction> savedActions = new HashMap<String, IAction>();
    private IActionBars actionBars;

    public GlobalActionDisablementHandler() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActivePart() != null) {
            IWorkbenchPartSite site = window.getActivePage().getActivePart().getSite();
            if (site instanceof IEditorSite) {
                this.actionBars = ((IEditorSite)site).getActionBars();
            } else if (site instanceof IViewSite) {
                this.actionBars = ((IViewSite)site).getActionBars();
            }
        }
    }

    public GlobalActionDisablementHandler(IActionBars actionBars) {
        this.actionBars = actionBars;
    }

    public void update() {
        if (this.actionBars != null) {
            this.actionBars.updateActionBars();
        }
    }

    public void clearGlobalActions() {
        if (this.actionBars != null) {
            String[] stringArray = actionIds;
            int n = actionIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IAction action = this.actionBars.getGlobalActionHandler(id);
                if (action != null) {
                    this.savedActions.put(id, action);
                    this.actionBars.setGlobalActionHandler(id, null);
                }
                ++n2;
            }
            this.actionBars.updateActionBars();
        }
    }

    public void restoreGlobalActions() {
        if (this.actionBars != null) {
            try {
                for (Map.Entry<String, IAction> entry : this.savedActions.entrySet()) {
                    this.actionBars.setGlobalActionHandler(entry.getKey(), entry.getValue());
                }
                this.savedActions.clear();
                this.actionBars.updateActionBars();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }
}

