/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.dialog;

import com.archimatetool.editor.ui.dialog.Messages;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ErrorMessageDialog
extends MessageDialog {
    private String longMessage;

    public static void open(Shell parentShell, String dialogTitle, String message, String longMessage) {
        ErrorMessageDialog dialog = new ErrorMessageDialog(parentShell, dialogTitle, message, longMessage, 1, 1, Messages.ErrorMessageDialog_0, IDialogConstants.OK_LABEL);
        dialog.open();
    }

    public static void open(Shell parentShell, String dialogTitle, String message, Throwable ex) {
        ErrorMessageDialog.open(parentShell, dialogTitle, message, ErrorMessageDialog.getExceptionAsString(ex));
    }

    public static boolean openWithQuestion(Shell parentShell, String dialogTitle, String message, Throwable ex) {
        return ErrorMessageDialog.openWithQuestion(parentShell, dialogTitle, message, ErrorMessageDialog.getExceptionAsString(ex));
    }

    public static boolean openWithQuestion(Shell parentShell, String dialogTitle, String message, String longMessage) {
        ErrorMessageDialog dialog = new ErrorMessageDialog(parentShell, dialogTitle, message, longMessage, 3, 2, Messages.ErrorMessageDialog_0, IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL);
        return dialog.open() == 1;
    }

    private static String getExceptionAsString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private ErrorMessageDialog(Shell parentShell, String dialogTitle, String dialogMessage, String longMessage, int dialogImageType, int defaultIndex, String ... dialogButtonLabels) {
        super(parentShell, dialogTitle, null, dialogMessage, dialogImageType, defaultIndex, dialogButtonLabels);
        this.longMessage = longMessage;
    }

    protected Control createCustomArea(Composite parent) {
        Text text = new Text(parent, 586);
        text.setText(this.longMessage);
        text.setBackground(text.getDisplay().getSystemColor(25));
        GridDataFactory.defaultsFor((Control)text).applyTo((Control)text);
        return text;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.longMessage != null) {
            Clipboard clipboard = null;
            try {
                clipboard = new Clipboard(this.getShell().getDisplay());
                clipboard.setContents(new Object[]{this.longMessage}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                if (clipboard != null) {
                    clipboard.dispose();
                }
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

