/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.dialog;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.components.ExtendedTitleAreaDialog;
import com.archimatetool.editor.ui.dialog.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class UserPropertiesKeySelectionDialog
extends ExtendedTitleAreaDialog {
    private static String HELP_ID = "com.archimatetool.help.userProperties";
    protected CheckboxTableViewer tableViewer;
    protected Button buttonSelectAll;
    protected Button buttonDeselectAll;
    protected List<String> keys;
    protected List<String> selectedKeys;

    public UserPropertiesKeySelectionDialog(Shell parentShell, List<String> keys, List<String> selected) {
        super(parentShell, "UserPropertiesKeySelectionDialog");
        this.setTitleImage(IArchiImages.ImageFactory.getImage("img/importpref_wiz.png"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.keys = keys;
        this.selectedKeys = selected;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        if (this.keys.size() == 0) {
            this.getButton(0).setEnabled(false);
            this.buttonSelectAll.setEnabled(false);
            this.buttonDeselectAll.setEnabled(false);
        }
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        this.getShell().setText(Messages.UserPropertiesKeySelectionDialog_0);
        this.setTitle(Messages.UserPropertiesKeySelectionDialog_1);
        this.setMessage(Messages.UserPropertiesKeySelectionDialog_2);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite client = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(1808));
        this.createTableControl(client);
        this.createButtonPanel(client);
        return composite;
    }

    protected void createTableControl(Composite parent) {
        Composite tableComp = new Composite(parent, 2048);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableComp.setLayoutData((Object)new GridData(1808));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComp, (int)65538);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.tableViewer.getTable().setLinesVisible(true);
        TableViewerColumn columnKey = new TableViewerColumn((TableViewer)this.tableViewer, 0, 0);
        tableLayout.setColumnData((Widget)columnKey.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return UserPropertiesKeySelectionDialog.this.keys.toArray();
            }

            public void dispose() {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setInput(this.keys);
        if (this.selectedKeys != null) {
            this.tableViewer.setCheckedElements(this.selectedKeys.toArray());
        }
    }

    protected void createButtonPanel(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        GridData gd = new GridData(2);
        client.setLayoutData((Object)gd);
        this.buttonSelectAll = new Button(client, 8);
        this.buttonSelectAll.setText(Messages.UserPropertiesKeySelectionDialog_3);
        gd = new GridData(768);
        this.buttonSelectAll.setLayoutData((Object)gd);
        this.buttonSelectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.tableViewer.setCheckedElements(this.keys.toArray())));
        this.buttonDeselectAll = new Button(client, 8);
        this.buttonDeselectAll.setText(Messages.UserPropertiesKeySelectionDialog_4);
        gd = new GridData(768);
        this.buttonDeselectAll.setLayoutData((Object)gd);
        this.buttonDeselectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.tableViewer.setCheckedElements(new Object[0])));
    }

    protected void buttonPressed(int buttonId) {
        this.selectedKeys = new ArrayList<String>();
        Object[] objectArray = this.tableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.selectedKeys.add((String)o);
            ++n2;
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    public List<String> getSelectedKeys() {
        return this.selectedKeys;
    }

    @Override
    protected Point getDefaultDialogSize() {
        return new Point(400, 250);
    }
}

