/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.factory;

import com.archimatetool.editor.Logger;
import com.archimatetool.editor.ui.factory.AbstractObjectUIProvider;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ObjectUIFactory {
    public static final ObjectUIFactory INSTANCE = new ObjectUIFactory();
    Map<EClass, IObjectUIProvider> map = new HashMap<EClass, IObjectUIProvider>();

    static {
        INSTANCE.registerProviders();
    }

    ObjectUIFactory() {
    }

    private void registerProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("com.archimatetool.editor.objectUIProvider");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String id = configurationElement.getAttribute("id");
                IObjectUIProvider provider = (IObjectUIProvider)configurationElement.createExecutableExtension("class");
                if (id != null && provider != null) {
                    this.registerProvider(provider);
                }
            }
            catch (CoreException ex) {
                Logger.logError("Cannot register UI Provider", ex);
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    void registerProvider(IObjectUIProvider provider) {
        if (provider != null && provider.providerFor() != null && this.map.get(provider.providerFor()) == null) {
            this.map.put(provider.providerFor(), provider);
        }
    }

    public IObjectUIProvider getProviderForClass(EClass eClass) {
        return eClass == null ? null : this.map.get(eClass);
    }

    public IObjectUIProvider getProvider(EObject eObject) {
        EClass eClass = null;
        if (eObject instanceof IDiagramModelArchimateComponent) {
            eClass = ((IDiagramModelArchimateComponent)eObject).getArchimateConcept().eClass();
        } else if (eObject != null) {
            eClass = eObject.eClass();
        }
        IObjectUIProvider provider = this.getProviderForClass(eClass);
        if (provider != null) {
            try {
                provider = (IObjectUIProvider)provider.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((AbstractObjectUIProvider)provider).setInstance(eObject);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return provider;
    }

    public List<IObjectUIProvider> getProviders() {
        return new ArrayList<IObjectUIProvider>(this.map.values());
    }
}

