/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.findreplace;

import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.findreplace.IFindReplaceProvider;
import com.archimatetool.editor.ui.findreplace.Messages;
import com.archimatetool.editor.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FindReplaceDialog
extends Dialog
implements IPartListener,
IDialogConstants {
    private static Map<IWorkbenchWindow, FindReplaceDialog> SINGLETONS = new HashMap<IWorkbenchWindow, FindReplaceDialog>();
    private static final int FIND_ID = 1025;
    private static final int FIND_ALL_ID = 1026;
    private static final int REPLACE_ID = 1027;
    private static final int REPLACE_ALL_ID = 1028;
    private static final String EMPTY = "";
    private static final String STRING_NOT_FOUND = Messages.FindReplaceDialog_0;
    private static final String DIALOG_ID = "FindReplaceDialog";
    private static final String SETTINGS_SECTION_NAME = "com.archimatetool.ui.findreplace";
    private static final String P_PARAMETER = "parameter";
    private static List<String> FindHistory = new ArrayList<String>();
    private static List<String> ReplaceHistory = new ArrayList<String>();
    private IWorkbenchWindow window;
    private IWorkbenchPart currentPart;
    private IFindReplaceProvider operationProvider;
    private int parameter = 20;
    private Label infoLabel;
    private Combo findInput;
    private Combo replaceInput;
    private Map<Integer, Button> opButtons = new HashMap<Integer, Button>();
    private Map<Integer, List<Button>> paramWidgets = new HashMap<Integer, List<Button>>();
    private Listener eventHandler = new EventHandler();

    public static FindReplaceDialog getInstance(IWorkbenchWindow window) {
        FindReplaceDialog instance = SINGLETONS.get(window);
        if (instance != null) {
            return instance;
        }
        return new FindReplaceDialog(window);
    }

    protected FindReplaceDialog(final IWorkbenchWindow window) {
        super(window.getShell());
        this.window = window;
        this.setShellStyle(112);
        SINGLETONS.put(window, this);
        window.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindReplaceDialog.this.close();
                SINGLETONS.remove(window);
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        IWorkbenchPart activePart = this.window.getActivePage().getActivePart();
        this.partActivated(activePart);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.FindReplaceDialog_1);
        this.loadParameter();
        this.startListeningToPartChanges();
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindReplaceDialog.this.saveParameter();
                FindReplaceDialog.this.stopListeningToPartChanges();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.verticalSpacing = 10;
        layout.marginTop = layout.marginHeight;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        this.createInputGroup(composite);
        this.createParameterGroups(composite);
        this.createOperationButtonGroup(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite container = new Composite(parent, 524288);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.verticalSpacing = 0;
        containerLayout.marginHeight = 7;
        containerLayout.marginWidth = 7;
        container.setLayout((Layout)containerLayout);
        this.infoLabel = new Label(container, 0);
        this.infoLabel.setBackground(container.getBackground());
        this.infoLabel.setFont(container.getFont());
        this.infoLabel.setForeground(container.getDisplay().getSystemColor(3));
        this.infoLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        Composite composite = (Composite)super.createButtonBar(container);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.close();
        } else if (1025 == buttonId) {
            this.findPressed();
        } else if (1026 == buttonId) {
            this.findAllPressed();
        } else if (1027 == buttonId) {
            this.replacePressed();
        } else if (1028 == buttonId) {
            this.replaceAllPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createInputGroup(Composite parent) {
        Composite composite = new Composite(parent, 524288);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout inputLayout = new GridLayout(2, false);
        inputLayout.marginWidth = 0;
        inputLayout.marginHeight = 0;
        composite.setLayout((Layout)inputLayout);
        this.findInput = this.createInputWidget(composite, Messages.FindReplaceDialog_2, FindHistory);
        this.replaceInput = this.createInputWidget(composite, Messages.FindReplaceDialog_3, ReplaceHistory);
    }

    private Combo createInputWidget(Composite parent, String label, List<String> history) {
        Label labelWidget = new Label(parent, 0);
        labelWidget.setText(label);
        labelWidget.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        Combo input = new Combo(parent, 2052);
        GridData layoutData = new GridData(4, 0x1000000, true, true);
        layoutData.widthHint = 200;
        input.setLayoutData((Object)layoutData);
        for (String t : history) {
            input.add(t);
        }
        if (!history.isEmpty()) {
            input.setText(history.get(0));
        }
        input.addListener(24, this.eventHandler);
        input.addListener(15, this.eventHandler);
        UIUtils.applyNewlineFilter((Control)input);
        return input;
    }

    protected void createOperationButtonGroup(Composite parent) {
        Composite buttons = new Composite(parent, 524288);
        buttons.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout buttonsLayout = new GridLayout(2, true);
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonsLayout);
        this.createOperationButton(buttons, 1025, Messages.FindReplaceDialog_4, true);
        this.createOperationButton(buttons, 1026, Messages.FindReplaceDialog_5, false);
        this.createOperationButton(buttons, 1027, Messages.FindReplaceDialog_6, false);
        this.createOperationButton(buttons, 1028, Messages.FindReplaceDialog_7, false);
    }

    protected Button createOperationButton(Composite parent, int id, String text, boolean defaultButton) {
        Shell shell;
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        button.setText(text);
        button.setData((Object)id);
        button.addListener(13, this.eventHandler);
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.registerOperationButton(id, button);
        return button;
    }

    private void registerOperationButton(final int id, final Button widget) {
        this.opButtons.put(id, widget);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindReplaceDialog.this.unregisterOperationButton(id, widget);
            }
        });
    }

    private void unregisterOperationButton(int id, Button widget) {
        Integer key = id;
        if (this.opButtons.get(key) == widget) {
            this.opButtons.remove(key);
        }
    }

    protected void updateOperationButtons() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        this.getButton(1025).setEnabled(this.canFind());
        this.getButton(1026).setEnabled(this.canFindAll());
        this.getButton(1027).setEnabled(this.canReplace());
        this.getButton(1028).setEnabled(this.canReplaceAll());
    }

    protected Button getButton(int id) {
        Button button = super.getButton(id);
        if (button == null) {
            button = this.opButtons.get(id);
        }
        return button;
    }

    protected boolean canFind() {
        return StringUtils.isSet(this.getFindText()) && this.operationProvider != null && this.operationProvider.canFind(this.getFindText());
    }

    protected boolean canFindAll() {
        return StringUtils.isSet(this.getFindText()) && this.operationProvider != null && this.operationProvider.canFindAll(this.getFindText());
    }

    protected boolean canReplace() {
        return this.canFind() && this.operationProvider.canReplace(this.getFindText(), this.getReplaceText());
    }

    protected boolean canReplaceAll() {
        return this.canFind() && this.operationProvider.canReplaceAll(this.getFindText(), this.getReplaceText());
    }

    protected void findPressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        if (this.operationProvider.find(this.getFindText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.findInput.setFocus();
    }

    protected void findAllPressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        boolean all = (this.parameter & 0x10000) != 0;
        this.operationProvider.setParameter(65536, true);
        if (this.operationProvider.find(this.getFindText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.operationProvider.setParameter(65536, all);
        this.findInput.setFocus();
    }

    protected void replacePressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        if (this.operationProvider.replace(this.getFindText(), this.getReplaceText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.findInput.setFocus();
    }

    protected void replaceAllPressed() {
        this.saveHistories();
        if (this.operationProvider == null) {
            return;
        }
        boolean all = (this.parameter & 0x10000) != 0;
        this.operationProvider.setParameter(65536, true);
        if (this.operationProvider.replace(this.getFindText(), this.getReplaceText())) {
            this.setInfoText(EMPTY);
        } else {
            this.setInfoText(STRING_NOT_FOUND);
        }
        this.operationProvider.setParameter(65536, all);
        this.findInput.setFocus();
    }

    public String getFindText() {
        return this.findInput == null || this.findInput.isDisposed() ? EMPTY : this.findInput.getText();
    }

    public String getReplaceText() {
        return this.replaceInput == null || this.replaceInput.isDisposed() ? EMPTY : this.replaceInput.getText();
    }

    protected void setInfoText(String text) {
        if (this.infoLabel != null && !this.infoLabel.isDisposed()) {
            this.infoLabel.setText(text);
            this.infoLabel.getParent().layout();
        }
    }

    protected void saveHistories() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        this.saveHistory(FindHistory, this.findInput);
        this.saveHistory(ReplaceHistory, this.replaceInput);
    }

    protected void saveHistory(List<String> history, Combo input) {
        String text = input.getText();
        if (text == null || EMPTY.equals(text)) {
            return;
        }
        if (history.remove(text) && !input.isDisposed()) {
            input.remove(text);
        }
        history.add(0, text);
        if (!input.isDisposed()) {
            input.add(text, 0);
            input.setText(text);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings(DIALOG_ID);
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    protected IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FindReplaceDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    private void loadParameter() {
        IDialogSettings settings = this.getDialogSettings(SETTINGS_SECTION_NAME);
        if (settings != null) {
            try {
                this.parameter = settings.getInt(P_PARAMETER);
            }
            catch (Exception exception) {}
        }
    }

    private void saveParameter() {
        IDialogSettings settings = this.getDialogSettings(SETTINGS_SECTION_NAME);
        if (settings != null) {
            settings.put(P_PARAMETER, this.parameter);
        }
    }

    protected void createParameterGroups(Composite parent) {
        Composite composite = new Composite(parent, 524288);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Composite directionGroup = this.createParameterGroup(composite, 1, Messages.FindReplaceDialog_8);
        this.createParameterWidget(directionGroup, 16, Messages.FindReplaceDialog_9, 4);
        this.createParameterWidget(directionGroup, 16, Messages.FindReplaceDialog_10, 8);
        Composite scopeGroup = this.createParameterGroup(composite, 1, Messages.FindReplaceDialog_11);
        this.createParameterWidget(scopeGroup, 16, Messages.FindReplaceDialog_12, 16);
        this.createParameterWidget(scopeGroup, 16, Messages.FindReplaceDialog_13, 32);
        Composite optionGroup = this.createParameterGroup(composite, 2, Messages.FindReplaceDialog_14);
        ((GridData)optionGroup.getLayoutData()).horizontalSpan = 2;
        this.createParameterWidget(optionGroup, 32, Messages.FindReplaceDialog_15, 1);
        this.createParameterWidget(optionGroup, 32, Messages.FindReplaceDialog_17, 64);
        this.createParameterWidget(optionGroup, 32, Messages.FindReplaceDialog_16, 2);
        this.createParameterWidget(optionGroup, 32, Messages.FindReplaceDialog_18, 128);
    }

    private Composite createParameterGroup(Composite composite, int numColumns, String text) {
        Group group = new Group(composite, 524288);
        group.setText(text);
        GridData groupLayoutData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)groupLayoutData);
        GridLayout groupLayout = new GridLayout(numColumns, true);
        groupLayout.horizontalSpacing = 7;
        groupLayout.verticalSpacing = 7;
        group.setLayout((Layout)groupLayout);
        return group;
    }

    protected Button createParameterWidget(Composite parent, int style, String text, int paramId) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        this.addParameterWidget(paramId, button);
        button.setData((Object)paramId);
        button.addListener(13, this.eventHandler);
        return button;
    }

    private void addParameterWidget(final int paramId, final Button widget) {
        Integer key = paramId;
        List<Button> widgets = this.paramWidgets.get(key);
        if (widgets == null) {
            widgets = new ArrayList<Button>();
            this.paramWidgets.put(key, widgets);
        }
        widgets.add(widget);
        this.paramWidgets.put(key, widgets);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FindReplaceDialog.this.removeParameterWidget(paramId, widget);
            }
        });
    }

    private void removeParameterWidget(int paramId, Button widget) {
        Integer key = paramId;
        List<Button> widgets = this.paramWidgets.get(key);
        if (widgets != null) {
            widgets.remove(widget);
            if (widgets.isEmpty()) {
                this.paramWidgets.remove(key);
            }
        }
    }

    private void updateParameterWidgets() {
        for (Integer paramId : this.paramWidgets.keySet()) {
            this.updateParameterWidget(paramId);
        }
    }

    private void updateParameterWidget(Integer paramId) {
        List<Button> widgets = this.paramWidgets.get(paramId);
        if (widgets != null) {
            boolean enabled = this.operationProvider != null && this.operationProvider.understandsParameter(paramId);
            for (Button widget : widgets) {
                widget.setEnabled(enabled);
                widget.setSelection(this.hasParameter(paramId));
            }
        }
    }

    private boolean hasParameter(int paramId) {
        if (this.operationProvider == null) {
            return false;
        }
        int bit = this.parameter & paramId;
        return bit != 0;
    }

    public boolean close() {
        this.saveHistories();
        return super.close();
    }

    public void partActivated(IWorkbenchPart part) {
        this.currentPart = part;
        this.setOperationProvider(this.getOperationProvider(part));
        this.updateOperationButtons();
        this.updateParameterWidgets();
    }

    public void partClosed(IWorkbenchPart part) {
        if (part != this.currentPart) {
            return;
        }
        this.setOperationProvider(null);
        this.updateOperationButtons();
        this.updateParameterWidgets();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private void startListeningToPartChanges() {
        this.window.getPartService().addPartListener((IPartListener)this);
    }

    private void stopListeningToPartChanges() {
        this.window.getPartService().removePartListener((IPartListener)this);
    }

    private IFindReplaceProvider getOperationProvider(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        return (IFindReplaceProvider)part.getAdapter(IFindReplaceProvider.class);
    }

    protected void setOperationProvider(IFindReplaceProvider operationProvider) {
        this.operationProvider = operationProvider;
        if (operationProvider != null) {
            operationProvider.setParameter(this.parameter);
        }
    }

    private class EventHandler
    implements Listener {
        private EventHandler() {
        }

        public void handleEvent(Event event) {
            if (event.type == 24) {
                FindReplaceDialog.this.updateOperationButtons();
                FindReplaceDialog.this.infoLabel.setText(FindReplaceDialog.EMPTY);
            } else if (event.type == 15) {
                if (event.widget instanceof Combo) {
                    Combo input = (Combo)event.widget;
                    input.setSelection(new Point(0, input.getText().length()));
                }
            } else if (event.type == 13) {
                Button b = (Button)event.widget;
                if (FindReplaceDialog.this.opButtons.containsValue(b)) {
                    FindReplaceDialog.this.buttonPressed((Integer)b.getData());
                } else {
                    List<Button> list = FindReplaceDialog.this.paramWidgets.get(b.getData());
                    if (list.contains(b)) {
                        int param = (Integer)b.getData();
                        FindReplaceDialog.this.parameter = b.getSelection() ? (FindReplaceDialog.this.parameter |= param) : (FindReplaceDialog.this.parameter &= ~param);
                        if (FindReplaceDialog.this.operationProvider != null) {
                            FindReplaceDialog.this.operationProvider.setParameter(param, b.getSelection());
                        }
                        FindReplaceDialog.this.updateOperationButtons();
                    }
                }
            }
        }
    }
}

