/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.ITextRenderer;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractTextRenderer
implements ITextRenderer {
    protected IArchimateModelObject getActualObject(IArchimateModelObject object) {
        if (object instanceof IDiagramModelArchimateComponent) {
            IDiagramModelArchimateComponent dmo = (IDiagramModelArchimateComponent)object;
            return dmo.getArchimateConcept();
        }
        if (object instanceof IDiagramModelReference) {
            IDiagramModelReference dmr = (IDiagramModelReference)object;
            return dmr.getReferencedModel();
        }
        return object;
    }

    protected IArchimateModelObject getObjectFromPrefix(IArchimateModelObject object, String prefix) {
        block15: {
            IArchimateModelObject actualObject;
            block14: {
                EObject eObject;
                actualObject = this.getActualObject(object);
                if (prefix == null) {
                    return actualObject;
                }
                if ("model".equals(prefix)) {
                    return object.getArchimateModel();
                }
                if ("view".equals(prefix) && object instanceof IDiagramModelComponent) {
                    IDiagramModelComponent dmc = (IDiagramModelComponent)object;
                    return dmc.getDiagramModel();
                }
                if ("mfolder".equals(prefix) && (eObject = actualObject.eContainer()) instanceof IFolder) {
                    IFolder folder = (IFolder)eObject;
                    return folder;
                }
                if ("vfolder".equals(prefix) && object instanceof IDiagramModelComponent) {
                    IDiagramModelComponent dmc = (IDiagramModelComponent)object;
                    IDiagramModel dm = dmc.getDiagramModel();
                    return dm != null ? (IArchimateModelObject)dm.eContainer() : null;
                }
                if ("parent".equals(prefix) && object != null) {
                    IArchimateModelObject parent = (IArchimateModelObject)object.eContainer();
                    return this.getActualObject(parent);
                }
                if ("source".equals(prefix) && object instanceof IDiagramModelConnection) {
                    IDiagramModelConnection dmc = (IDiagramModelConnection)object;
                    return this.getActualObject((IArchimateModelObject)dmc.getSource());
                }
                if ("target".equals(prefix) && object instanceof IDiagramModelConnection) {
                    IDiagramModelConnection dmc = (IDiagramModelConnection)object;
                    return this.getActualObject((IArchimateModelObject)dmc.getTarget());
                }
                if (!prefix.endsWith(":source") || !(object instanceof IConnectable)) break block14;
                IConnectable connectable = (IConnectable)object;
                prefix = prefix.replace(":source", "");
                for (IDiagramModelConnection connection : connectable.getTargetConnections()) {
                    IArchimateModelObject actualConnection = this.getActualObject((IArchimateModelObject)connection);
                    if (!actualConnection.eClass().getName().toLowerCase().contains(prefix)) continue;
                    return this.getActualObject((IArchimateModelObject)connection.getSource());
                }
                if (!(actualObject instanceof IArchimateConcept)) break block15;
                IArchimateConcept concept = (IArchimateConcept)actualObject;
                for (IArchimateRelationship relationship : concept.getTargetRelationships()) {
                    if (!relationship.eClass().getName().toLowerCase().contains(prefix)) continue;
                    return relationship.getSource();
                }
                break block15;
            }
            if (prefix.endsWith(":target") && object instanceof IConnectable) {
                IConnectable connectable = (IConnectable)object;
                prefix = prefix.replace(":target", "");
                for (IDiagramModelConnection connection : connectable.getSourceConnections()) {
                    IArchimateModelObject actualConnection = this.getActualObject((IArchimateModelObject)connection);
                    if (!actualConnection.eClass().getName().toLowerCase().contains(prefix)) continue;
                    return this.getActualObject((IArchimateModelObject)connection.getTarget());
                }
                if (actualObject instanceof IArchimateConcept) {
                    IArchimateConcept concept = (IArchimateConcept)actualObject;
                    for (IArchimateRelationship relationship : concept.getSourceRelationships()) {
                        if (!relationship.eClass().getName().toLowerCase().contains(prefix)) continue;
                        return relationship.getTarget();
                    }
                }
            }
        }
        return null;
    }
}

