/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.AbstractTextRenderer;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDocumentable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentationRenderer
extends AbstractTextRenderer {
    private static final Pattern DOCUMENTATION_PATTERN = Pattern.compile("\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{(documentation|doc)\\}");

    @Override
    public String render(IArchimateModelObject object, String text) {
        Matcher matcher = DOCUMENTATION_PATTERN.matcher(text);
        while (matcher.find()) {
            String prefix = matcher.group(1);
            String replacement = "";
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (refObject instanceof IDocumentable) {
                replacement = ((IDocumentable)refObject).getDocumentation();
            } else if (refObject instanceof IArchimateModel) {
                replacement = ((IArchimateModel)refObject).getPurpose();
            }
            text = text.replace(matcher.group(), replacement);
        }
        return text;
    }
}

