/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.AbstractTextRenderer;
import com.archimatetool.model.IArchimateModelObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IfRenderer
extends AbstractTextRenderer {
    private static final String startOfExpression = "\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{";
    private static final String notStartOfExpression = "(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)";
    private static final String acceptedChar = "(?:[^:\\}\\\\]|\\\\:|\\\\\\\\)";
    private static final String textWithoutExpressions = "(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*";
    private static final Pattern IF_THEN_ELSE_PATTERN = Pattern.compile("\\$\\{if:(?<IF>(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*):(?<THEN>(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*):(?<ELSE>(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*)\\}");
    private static final Pattern IF_THEN_PATTERN = Pattern.compile("\\$\\{if:(?<IF>(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*):(?<THEN>(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*)\\}");
    private static final Pattern NVL_PATTERN = Pattern.compile("\\$\\{nvl:(?<COND>(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*):(?<ALT>(?:\\\\:|(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)(?:[^:\\}\\\\]|\\\\:|\\\\\\\\))*)\\}");

    @Override
    public String render(IArchimateModelObject object, String text) {
        if (text.contains("{if:")) {
            text = this.renderIfThenElse(text);
            text = this.renderIfThen(text);
        }
        if (text.contains("{nvl:")) {
            text = this.renderNvl(text);
        }
        return text;
    }

    private String renderIfThen(String text) {
        Matcher matcher = IF_THEN_PATTERN.matcher(text);
        while (matcher.find()) {
            String ifCondition = matcher.group("IF");
            String ifThen = matcher.group("THEN");
            String s = "";
            s = ifCondition.isBlank() ? "" : ifThen;
            s = s == null ? "" : s;
            text = text.replace(matcher.group(), s);
        }
        return text;
    }

    private String renderIfThenElse(String text) {
        Matcher matcher = IF_THEN_ELSE_PATTERN.matcher(text);
        while (matcher.find()) {
            String ifCondition = matcher.group("IF");
            String ifThen = matcher.group("THEN");
            String ifElse = matcher.group("ELSE");
            String s = "";
            s = ifCondition.isBlank() ? ifElse : ifThen;
            s = s == null ? "" : s;
            text = text.replace(matcher.group(), s);
        }
        return text;
    }

    private String renderNvl(String text) {
        Matcher matcher = NVL_PATTERN.matcher(text);
        while (matcher.find()) {
            String nvlCondition = matcher.group("COND");
            String nvlAlternate = matcher.group("ALT");
            String s = "";
            s = nvlCondition.isBlank() ? nvlAlternate : nvlCondition;
            s = s == null ? "" : s;
            text = text.replace(matcher.group(), s);
        }
        return text;
    }
}

