/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.AbstractTextRenderer;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesRenderer
extends AbstractTextRenderer {
    private static final String startOfExpression = "\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{";
    private static final String notStartOfExpression = "(?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)";
    private static final String acceptedKeyChar = "[^\\}]";
    private static final String key = "((?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)[^\\}])+";
    private static final Pattern PROPERTY_VALUE_PATTERN = Pattern.compile("\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{property:(((?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)[^\\}])+)\\}");
    private static final Pattern PROPERTIES_PATTERN = Pattern.compile("\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{properties\\}");
    private static final Pattern PROPERTIES_VALUES_PATTERN = Pattern.compile("\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{propertiesvalues\\}");
    private static final Pattern FILTERED_PROPERTIES_WITH_SEPARATOR_PATTERN = Pattern.compile("\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{properties:([^:]*):(((?!\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{)[^\\}])+)\\}");

    @Override
    public String render(IArchimateModelObject object, String text) {
        text = this.renderPropertyValue(object, text);
        text = this.renderPropertiesList(object, text);
        text = this.renderPropertiesValues(object, text);
        text = this.renderPropertiesValuesCustomList(object, text);
        return text;
    }

    private String renderPropertyValue(IArchimateModelObject object, String text) {
        Matcher matcher = PROPERTY_VALUE_PATTERN.matcher(text);
        while (matcher.find()) {
            IProperty property;
            String prefix = matcher.group(1);
            String key = matcher.group(2);
            String propertyValue = "";
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (refObject instanceof IProperties && (property = this.getProperty((IProperties)refObject, key)) != null) {
                propertyValue = property.getValue();
            }
            text = text.replace(matcher.group(), propertyValue);
        }
        return text;
    }

    private String renderPropertiesList(IArchimateModelObject object, String text) {
        Matcher matcher = PROPERTIES_PATTERN.matcher(text);
        while (matcher.find()) {
            String prefix = matcher.group(1);
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (!(refObject instanceof IProperties)) continue;
            text = text.replace(matcher.group(), this.getAllProperties((IProperties)refObject, true));
        }
        return text;
    }

    private String renderPropertiesValues(IArchimateModelObject object, String text) {
        Matcher matcher = PROPERTIES_VALUES_PATTERN.matcher(text);
        while (matcher.find()) {
            String prefix = matcher.group(1);
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (!(refObject instanceof IProperties)) continue;
            text = text.replace(matcher.group(), this.getAllProperties((IProperties)refObject, false));
        }
        return text;
    }

    private String renderPropertiesValuesCustomList(IArchimateModelObject object, String text) {
        Matcher matcher = FILTERED_PROPERTIES_WITH_SEPARATOR_PATTERN.matcher(text);
        while (matcher.find()) {
            String prefix = matcher.group(1);
            String separator = matcher.group(2);
            String key = matcher.group(3);
            Object s = "";
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (!(refObject instanceof IProperties)) continue;
            for (IProperty property : ((IProperties)refObject).getProperties()) {
                if (!property.getKey().equals(key)) continue;
                if (!((String)s).isEmpty()) {
                    s = (String)s + separator;
                }
                s = (String)s + property.getValue();
            }
            text = text.replace(matcher.group(), (CharSequence)s);
        }
        return text;
    }

    private String getAllProperties(IProperties object, boolean full) {
        Object s = "";
        int i = 0;
        while (i < object.getProperties().size()) {
            IProperty property = (IProperty)object.getProperties().get(i);
            if (full) {
                s = (String)s + property.getKey() + ": ";
            }
            s = (String)s + property.getValue();
            if (i < object.getProperties().size() - 1) {
                s = (String)s + "\n";
            }
            ++i;
        }
        return s;
    }

    private IProperty getProperty(IProperties object, String key) {
        for (IProperty property : object.getProperties()) {
            if (!property.getKey().equals(key)) continue;
            return property;
        }
        return null;
    }
}

