/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.AbstractTextRenderer;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecializationRenderer
extends AbstractTextRenderer {
    private static final Pattern NAME_PATTERN = Pattern.compile("\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{specialization\\}");

    @Override
    public String render(IArchimateModelObject object, String text) {
        Matcher matcher = NAME_PATTERN.matcher(text);
        while (matcher.find()) {
            IProfile profile;
            String prefix = matcher.group(1);
            String replacement = "";
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (refObject instanceof IProfiles && (profile = ((IProfiles)refObject).getPrimaryProfile()) != null) {
                replacement = profile.getName();
            }
            text = text.replace(matcher.group(), replacement);
        }
        return text;
    }
}

