/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.AbstractTextRenderer;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.ITextContent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextContentRenderer
extends AbstractTextRenderer {
    private static final Pattern CONTENT_PATTERN = Pattern.compile("\\$(connection:(?:source|target))?\\{content\\}");

    @Override
    public String render(IArchimateModelObject object, String text) {
        Matcher matcher = CONTENT_PATTERN.matcher(text);
        while (matcher.find()) {
            String prefix = matcher.group(1);
            String replacement = "";
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (refObject instanceof ITextContent) {
                replacement = ((ITextContent)refObject).getContent();
            }
            text = text.replace(matcher.group(), replacement);
        }
        return text;
    }
}

