/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.textrender.DocumentationRenderer;
import com.archimatetool.editor.ui.textrender.ITextRenderer;
import com.archimatetool.editor.ui.textrender.IfRenderer;
import com.archimatetool.editor.ui.textrender.NameRenderer;
import com.archimatetool.editor.ui.textrender.PropertiesRenderer;
import com.archimatetool.editor.ui.textrender.RelationshipRenderer;
import com.archimatetool.editor.ui.textrender.SpecializationRenderer;
import com.archimatetool.editor.ui.textrender.TextContentRenderer;
import com.archimatetool.editor.ui.textrender.TypeRenderer;
import com.archimatetool.editor.ui.textrender.ViewpointRenderer;
import com.archimatetool.editor.ui.textrender.WordWrapRenderer;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelNote;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.util.Logger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class TextRenderer {
    public static final String FEATURE_NAME = "labelExpression";
    private Set<ITextRenderer> renderers = new LinkedHashSet<ITextRenderer>();
    private static TextRenderer defaultTextRenderer = new TextRenderer();

    public static TextRenderer getDefault() {
        return defaultTextRenderer;
    }

    private TextRenderer() {
        this.registerRenderer(new NameRenderer());
        this.registerRenderer(new DocumentationRenderer());
        this.registerRenderer(new TypeRenderer());
        this.registerRenderer(new SpecializationRenderer());
        this.registerRenderer(new PropertiesRenderer());
        this.registerRenderer(new TextContentRenderer());
        this.registerRenderer(new RelationshipRenderer());
        this.registerRenderer(new ViewpointRenderer());
        this.registerRenderer(new IfRenderer());
        this.registerRenderer(new WordWrapRenderer());
    }

    public String render(IArchimateModelObject object) {
        return this.render(object, "");
    }

    public String render(IArchimateModelObject object, String defaultText) {
        return this.renderWithExpression(object, this.getFormatExpression(object), defaultText);
    }

    public String renderWithExpression(IArchimateModelObject object, String formatExpression) {
        return this.renderWithExpression(object, formatExpression, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String renderWithExpression(IArchimateModelObject object, String formatExpression, String defaultText) {
        if (!StringUtils.isSet(formatExpression)) {
            return defaultText;
        }
        String result = this.renderNewLines(formatExpression);
        HashSet<String> resultSet = new HashSet<String>();
        try {
            block2: while (true) {
                resultSet.add(result);
                if (resultSet.size() == 10) {
                    return "*** Recursion Error in Label Expression ***";
                }
                Iterator<ITextRenderer> iterator = this.renderers.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (!resultSet.contains(result)) continue block2;
                        return this.renderEscapedCharacters(result);
                    }
                    ITextRenderer r = iterator.next();
                    result = r.render(object, result);
                }
                break;
            }
        }
        catch (Throwable t) {
            Logger.logError((String)"Error in Label Expression", (Throwable)t);
            return "*** Error in Label Expression ***";
        }
    }

    public boolean hasFormatExpression(IArchimateModelObject object) {
        return this.getFormatExpression(object) != null;
    }

    public String getFormatExpression(IArchimateModelObject object) {
        return object.getFeatures().getString(FEATURE_NAME, null);
    }

    public String getFormatExpressionFromAncestorFolder(IArchimateModelObject object) {
        if (object != null && object.eContainer() instanceof IFolder) {
            String expression = null;
            IFolder parent = (IFolder)object.eContainer();
            do {
                expression = this.getFormatExpression((IArchimateModelObject)parent);
                parent = (IArchimateModelObject)parent.eContainer();
            } while (expression == null && parent instanceof IFolder);
            return expression;
        }
        return null;
    }

    public void registerRenderer(ITextRenderer renderer) {
        this.renderers.add(renderer);
    }

    public boolean isSupportedObject(Object object) {
        return object instanceof IDiagramModelArchimateComponent && !(((IDiagramModelArchimateComponent)object).getArchimateConcept() instanceof IJunction) || object instanceof IDiagramModelNote || object instanceof IDiagramModelGroup || object instanceof IDiagramModelReference || object instanceof IDiagramModelConnection || object instanceof IFolder;
    }

    private String renderNewLines(String result) {
        return result.replace("\\n", "\n");
    }

    private String renderEscapedCharacters(String result) {
        return result.replace("\\:", ":").replace("\\\\", "\\");
    }
}

