/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.ui.textrender;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.textrender.AbstractTextRenderer;
import com.archimatetool.model.IArchimateModelObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeRenderer
extends AbstractTextRenderer {
    private static final Pattern TYPE_PATTERN = Pattern.compile("\\$(mfolder|vfolder|model|view|source|target|parent|(?:connection:|triggering:|access:|specialization:|composition:|assignment:|aggregation:|realization:|serving:|influence:|flow:|association:)(?:source|target))?\\{type\\}");

    @Override
    public String render(IArchimateModelObject object, String text) {
        Matcher matcher = TYPE_PATTERN.matcher(text);
        while (matcher.find()) {
            String prefix = matcher.group(1);
            String replacement = "";
            IArchimateModelObject refObject = this.getObjectFromPrefix(object, prefix);
            if (refObject != null) {
                replacement = ArchiLabelProvider.INSTANCE.getDefaultName(refObject.eClass());
            }
            text = text.replace(matcher.group(), replacement);
        }
        return text;
    }
}

