/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.utils;

import com.archimatetool.editor.utils.Messages;
import com.archimatetool.editor.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;

public final class FileUtils {
    public static int fFileNameCounter = -1;

    private FileUtils() {
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(i).toLowerCase();
        }
        return "";
    }

    public static String getFileNameWithoutExtension(File file) {
        String fileName = file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    public static long getFileSize(File[] files) {
        long num = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            num = file.isDirectory() ? (num += FileUtils.getFileSize(file.listFiles())) : (num += file.length());
            ++n2;
        }
        return num;
    }

    public static void deleteFiles(File[] files) throws IOException {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtils.deleteFolder(file);
            } else {
                file.delete();
            }
            ++n2;
        }
    }

    public static void copyFiles(File[] files, File destFolder, IProgressMonitor progressMonitor) throws IOException {
        if (!destFolder.isDirectory()) {
            throw new IOException("Parent folder should be directory");
        }
        if (progressMonitor != null) {
            progressMonitor.setTaskName(Messages.FileUtils_0);
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                File target = new File(destFolder, file.getName());
                if (file.isDirectory()) {
                    FileUtils.copyFolder(file, target, progressMonitor);
                } else {
                    FileUtils.copyFile(file, target, true);
                }
            }
            ++n2;
        }
    }

    public static void moveFiles(File[] files, File destFolder, IProgressMonitor progressMonitor) throws IOException {
        if (!destFolder.isDirectory()) {
            throw new IOException("Parent folder should be directory");
        }
        if (progressMonitor != null) {
            progressMonitor.setTaskName(Messages.FileUtils_1);
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                File target = new File(destFolder, file.getName());
                if (file.isDirectory()) {
                    FileUtils.moveFolder(file, target, progressMonitor);
                } else {
                    FileUtils.moveFile(file, target);
                }
            }
            ++n2;
        }
    }

    public static void copyFolder(File srcFolder, File destFolder, IProgressMonitor progressMonitor) throws IOException {
        if (srcFolder.equals(destFolder)) {
            throw new IOException("Source and target folders cannot be the same.");
        }
        if (!srcFolder.exists()) {
            throw new IOException("Source folder does not exist");
        }
        File dest = destFolder.getParentFile();
        while (dest != null) {
            if (dest.equals(srcFolder)) {
                throw new IOException("The destination folder cannot be a subfolder of the source folder.");
            }
            dest = dest.getParentFile();
        }
        destFolder.mkdirs();
        File[] srcFiles = srcFolder.listFiles();
        int i = 0;
        while (i < srcFiles.length) {
            File srcFile = srcFiles[i];
            if (progressMonitor != null) {
                progressMonitor.subTask(srcFile.getName());
                if (progressMonitor.isCanceled()) {
                    throw new IOException("User cancelled.");
                }
            }
            if (srcFile.isDirectory()) {
                FileUtils.copyFolder(srcFile, new File(destFolder, srcFile.getName()), progressMonitor);
            } else {
                FileUtils.copyFile(srcFile, new File(destFolder, srcFile.getName()), false);
            }
            ++i;
        }
    }

    public static void copyFolder(File srcFolder, File destFolder) throws IOException {
        FileUtils.copyFolder(srcFolder, destFolder, null);
    }

    public static void copyFile(File srcFile, File destFile, boolean createCopy) throws IOException {
        int size;
        if (createCopy) {
            if (srcFile.equals(destFile) || destFile.exists()) {
                int i = 1;
                String name = FileUtils.getFileNameWithoutExtension(srcFile);
                String ext = FileUtils.getFileExtension(srcFile);
                while ((destFile = new File(destFile.getParentFile(), name + "(" + i++ + ")" + ext)).exists()) {
                }
            }
        } else if (srcFile.equals(destFile)) {
            throw new IOException("Source and Target Files cannot be the same");
        }
        int bufSize = 65536;
        byte[] buf = new byte[bufSize];
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile), bufSize);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile), bufSize);
        while ((size = bis.read(buf)) != -1) {
            bos.write(buf, 0, size);
        }
        bos.flush();
        bos.close();
        bis.close();
    }

    public static void moveFolder(File srcFolder, File destFolder, IProgressMonitor progressMonitor) throws IOException {
        FileUtils.copyFolder(srcFolder, destFolder, progressMonitor);
        FileUtils.deleteFolder(srcFolder);
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        FileUtils.copyFile(srcFile, destFile, false);
        srcFile.delete();
    }

    public static void deleteFolder(File afolder) throws IOException {
        if (afolder == null) {
            return;
        }
        File parent = new File(afolder.getAbsolutePath()).getParentFile();
        if (parent == null) {
            throw new IOException("Cannot delete root folder");
        }
        if (afolder.exists() && afolder.isDirectory()) {
            File[] files = afolder.listFiles();
            int count = files.length;
            int i = 0;
            while (i < count) {
                File f = files[i];
                if (f.isFile()) {
                    f.delete();
                } else if (f.isDirectory()) {
                    FileUtils.deleteFolder(f);
                }
                ++i;
            }
            afolder.delete();
        }
    }

    public static File[] sortFiles(File[] files) {
        if (files == null || files.length == 0) {
            return files;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                if (f1 == null || f2 == null) {
                    return 0;
                }
                if (f1.isDirectory() && f2.isFile()) {
                    return -1;
                }
                if (f1.isFile() && f2.isDirectory()) {
                    return 1;
                }
                return f1.compareTo(f2);
            }
        });
        return files;
    }

    public static String getRelativePath(File path, File basePath) {
        try {
            String dir = path.toURL().toExternalForm();
            String baseDir = FileUtils.appendSeparator(basePath.toURL().toExternalForm(), "/");
            StringBuffer result = new StringBuffer();
            while (dir.indexOf(baseDir) == -1) {
                if ((basePath = basePath.getParentFile()) == null) {
                    return path.getName();
                }
                baseDir = FileUtils.appendSeparator(basePath.toURL().toExternalForm(), "/");
                result.append("../");
            }
            if (dir.indexOf(baseDir) == 0) {
                String delta = dir.substring(baseDir.length());
                result.append(delta);
            }
            return result.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return path.getName();
        }
    }

    public static String appendSeparator(String path) {
        return FileUtils.appendSeparator(path, File.separator);
    }

    public static String appendSeparator(String path, String separator) {
        return path.endsWith(separator) ? path : path + separator;
    }

    public static String generateFileName(File folder, String prefix, String suffix) {
        File tmpFile;
        if (fFileNameCounter == -1) {
            fFileNameCounter = new Random().nextInt() & 0xFFFF;
        }
        while ((tmpFile = new File(folder, prefix + Integer.toString(++fFileNameCounter) + "." + suffix)).exists()) {
        }
        return tmpFile.getName();
    }

    public static String getValidFileName(String name) {
        if (!StringUtils.isSet(name)) {
            return "untitled";
        }
        return name.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public static boolean isFolderEmpty(File folder) throws IOException {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            return true;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> entries = Files.list(folder.toPath()).filter(path -> !path.endsWith(".DS_Store"));){
            return entries.findFirst().isEmpty();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

