/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.utils;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.Logger;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public final class NetUtils {
    private static final ProxySelector DEFAULT_PROXY_SELECTOR = ProxySelector.getDefault();
    private static Authenticator AUTHENTICATOR = new Authenticator(){

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                ISecurePreferences archiNode = SecurePreferencesFactory.getDefault().node("com.archimatetool.editor");
                try {
                    String userName = archiNode.get("proxyUserName", "");
                    String pw = archiNode.get("proxyPassword", "");
                    return new PasswordAuthentication(userName, pw.toCharArray());
                }
                catch (StorageException ex) {
                    ex.printStackTrace();
                    Logger.logError("Could not get secure storage", ex);
                }
            }
            return null;
        }
    };

    public static void initialise() {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
        System.setProperty("sun.net.client.defaultConnectTimeout", Integer.toString(NetUtils.getNetworkTimeout()));
        System.setProperty("sun.net.client.defaultReadTimeout", Integer.toString(NetUtils.getNetworkTimeout()));
        NetUtils.setDefaultProxy();
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(event -> {
            if (event.getProperty() == "proxyEnabled" || event.getProperty() == "proxyAuthenticate" || event.getProperty() == "proxyHost" || event.getProperty() == "proxyPort") {
                NetUtils.setDefaultProxy();
            }
        });
    }

    public static URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = null;
        if (NetUtils.isProxyEnabled()) {
            connection = url.openConnection(NetUtils.getHTTPProxy());
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setAuthenticator(AUTHENTICATOR);
            }
        } else {
            connection = url.openConnection();
        }
        connection.setConnectTimeout(NetUtils.getNetworkTimeout());
        connection.setReadTimeout(NetUtils.getNetworkTimeout());
        return connection;
    }

    public static void setDefaultProxy() {
        if (!NetUtils.isProxyEnabled()) {
            ProxySelector.setDefault(DEFAULT_PROXY_SELECTOR);
            return;
        }
        if (NetUtils.isProxyAuthenticated()) {
            Authenticator.setDefault(AUTHENTICATOR);
        }
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Arrays.asList(NetUtils.getHTTPProxy());
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ex) {
                ex.printStackTrace();
                Logger.logError("Proxy connect failed", ex);
            }
        });
    }

    public static boolean isProxyEnabled() {
        return ArchiPlugin.getInstance().getPreferenceStore().getBoolean("proxyEnabled");
    }

    public static boolean isProxyAuthenticated() {
        return ArchiPlugin.getInstance().getPreferenceStore().getBoolean("proxyAuthenticate");
    }

    public static String getProxyHost() {
        return ArchiPlugin.getInstance().getPreferenceStore().getString("proxyHost");
    }

    public static int getProxyPort() {
        return ArchiPlugin.getInstance().getPreferenceStore().getInt("proxyPort");
    }

    public static int getNetworkTimeout() {
        return ArchiPlugin.getInstance().getPreferenceStore().getInt("networkTimeout");
    }

    private static Proxy getHTTPProxy() {
        InetSocketAddress socketAddress = new InetSocketAddress(NetUtils.getProxyHost(), NetUtils.getProxyPort());
        return new Proxy(Proxy.Type.HTTP, socketAddress);
    }
}

