/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.utils;

import com.archimatetool.editor.utils.StringUtils;
import java.io.File;
import org.eclipse.core.runtime.Platform;

public class PlatformUtils {
    public static boolean isWindows() {
        return Platform.getOS().equals("win32");
    }

    public static boolean isMac() {
        return Platform.getOS().equals("macosx");
    }

    public static boolean isLinux() {
        return Platform.getOS().equals("linux");
    }

    public static boolean isGTK() {
        return "gtk".equals(Platform.getWS());
    }

    public static boolean isX86_64() {
        return Platform.getOSArch().equals("x86_64");
    }

    public static boolean isAarch64() {
        return Platform.getOSArch().equals("aarch64");
    }

    public static boolean isAppleSilicon() {
        return PlatformUtils.isMac() && PlatformUtils.isAarch64();
    }

    public static boolean isLinuxWayland() {
        return PlatformUtils.isLinux() && "wayland".equalsIgnoreCase(System.getenv("XDG_SESSION_TYPE"));
    }

    public static boolean isLinuxX11() {
        return PlatformUtils.isLinux() && "x11".equalsIgnoreCase(System.getenv("XDG_SESSION_TYPE"));
    }

    public static boolean isOSVersion(String version) {
        return System.getProperty("os.version").equals(version);
    }

    public static boolean isWindows11() {
        return System.getProperty("os.name").equals("Windows 11");
    }

    public static int compareOSVersion(String version) {
        String current = System.getProperty("os.version");
        return StringUtils.compareVersionNumbers(current, version);
    }

    public static File getApplicationDataFolder() {
        if (PlatformUtils.isWindows()) {
            return new File(System.getenv("APPDATA"));
        }
        if (PlatformUtils.isLinux()) {
            return new File(System.getProperty("user.home"));
        }
        if (PlatformUtils.isMac()) {
            return new File(System.getProperty("user.home"), "Library/Application Support");
        }
        return new File(System.getProperty("user.home"));
    }
}

