/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.utils;

public final class StringUtils {
    public static final String ZERO_LENGTH_STRING = "";

    public static String safeString(String input) {
        return input != null ? input : ZERO_LENGTH_STRING;
    }

    public static boolean isSet(String input) {
        return input != null && input.length() > 0;
    }

    public static boolean isSetAfterTrim(String input) {
        return StringUtils.isSet(input) && input.trim().length() > 0;
    }

    public static String getStringCharacters(String s, int amount) {
        if (amount < 1) {
            return ZERO_LENGTH_STRING;
        }
        Object ret = s;
        int i = 1;
        while (i < amount) {
            ret = (String)ret + s;
            ++i;
        }
        return ret;
    }

    public static boolean isValidID(String id) {
        if (!StringUtils.isSet(id)) {
            return false;
        }
        return id.matches("[a-zA-Z_][\\w-_.]*");
    }

    public static String getValidID(String id) {
        if (!StringUtils.isSet(id)) {
            return id;
        }
        return id.replaceAll("[^a-zA-Z0-9-]", "_");
    }

    public static String escapeAmpersandsInText(String text) {
        if (StringUtils.isSet(text)) {
            return text.replace("&", "&&");
        }
        return text;
    }

    public static String replaceNewLineCharacters(String text, String replace) {
        if (StringUtils.isSet(text)) {
            return text.replaceAll("(\r\n|\r|\n)", replace);
        }
        return text;
    }

    public static String normaliseNewLineCharacters(String text) {
        if (StringUtils.isSet(text)) {
            return text.replaceAll("(\r\n|\r|\n)+", " ");
        }
        return text;
    }

    public static int compareVersionNumbers(String newer, String older) {
        return Integer.compare(StringUtils.versionNumberAsInt(newer), StringUtils.versionNumberAsInt(older));
    }

    static int versionNumberAsInt(String version) {
        if (!StringUtils.isSet(version)) {
            return 0;
        }
        String[] vals = version.split("\\.");
        try {
            if (vals.length == 1) {
                return Integer.parseInt(vals[0]) << 16;
            }
            if (vals.length == 2) {
                return (Integer.parseInt(vals[0]) << 16) + (Integer.parseInt(vals[1]) << 8);
            }
            if (vals.length == 3) {
                return (Integer.parseInt(vals[0]) << 16) + (Integer.parseInt(vals[1]) << 8) + Integer.parseInt(vals[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }
}

