/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.textrender.TextRenderer;
import com.archimatetool.editor.views.IModelView;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractModelView
extends ViewPart
implements IContextProvider,
PropertyChangeListener,
ITabbedPropertySheetPageContributor,
IModelView {
    private static final CommandStack EMPTY_COMMANDSTACK = new CommandStack();
    protected UndoAction fActionUndo = new UndoAction((IWorkbenchPart)this);
    protected RedoAction fActionRedo = new RedoAction((IWorkbenchPart)this);
    private IPropertyChangeListener prefsListener;
    protected IAction fActionSelectAll = new Action(){

        public void run() {
            AbstractModelView.this.selectAll();
        }
    };
    private List<Notification> notificationBuffer;

    public void createPartControl(Composite parent) {
        this.doCreatePartControl(parent);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.fActionUndo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.fActionRedo);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.fActionSelectAll);
        IEditorModelManager.INSTANCE.addPropertyChangeListener(this);
        this.hookSelectionListener();
        this.prefsListener = this::applicationPreferencesChanged;
        ArchiPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(this.prefsListener);
    }

    private void hookSelectionListener() {
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selected == null) {
                    selected = AbstractModelView.this.getViewer().getInput();
                }
                AbstractModelView.this.updateStatusBarWithSelection(selected);
                AbstractModelView.this.updateShellTitleBarWithFileName();
            }
        });
    }

    protected void updateStatusBarWithSelection(Object selected) {
        IStatusLineManager status = this.getViewSite().getActionBars().getStatusLineManager();
        if (selected instanceof IArchimateModelObject) {
            IArchimateModelObject object = (IArchimateModelObject)selected;
            Image image = ArchiLabelProvider.INSTANCE.getImage(object);
            Object text = "";
            ArrayList<String> list = new ArrayList<String>();
            do {
                list.add(ArchiLabelProvider.INSTANCE.getLabelNormalised(object));
            } while ((object = (IArchimateModelObject)object.eContainer()) != null);
            int i = list.size() - 1;
            while (i >= 0) {
                text = (String)text + (String)list.get(i);
                if (i != 0) {
                    text = (String)text + " > ";
                }
                --i;
            }
            status.setMessage(image, (String)text);
        } else {
            status.setMessage(null, "");
        }
    }

    protected void updateShellTitleBarWithFileName() {
        String appname = ArchiPlugin.getInstance().getProductName();
        if (this.getActiveArchimateModel() != null && this.getActiveArchimateModel().getFile() != null) {
            this.getSite().getShell().setText(appname + " - " + this.getActiveArchimateModel().getFile().getPath());
        } else {
            this.getSite().getShell().setText(appname);
        }
    }

    protected abstract void doCreatePartControl(Composite var1);

    protected void selectAll() {
    }

    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
    }

    protected void updateUndoActions() {
        this.fActionUndo.update();
        this.fActionRedo.update();
    }

    public String getContributorId() {
        return "com.archimatetool.editor";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (adapter == IArchimateModel.class) {
            return adapter.cast(this.getActiveArchimateModel());
        }
        if (adapter == CommandStack.class) {
            IArchimateModel model = this.getActiveArchimateModel();
            if (model != null) {
                return adapter.cast(model.getAdapter(CommandStack.class));
            }
            return adapter.cast(EMPTY_COMMANDSTACK);
        }
        return (T)super.getAdapter(adapter);
    }

    protected abstract IArchimateModel getActiveArchimateModel();

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if (propertyName == "IEditorModelManager.ecore.events.start") {
            if (this.notificationBuffer == null) {
                this.notificationBuffer = new ArrayList<Notification>();
            }
        } else if (propertyName == "IEditorModelManager.ecore.events.end") {
            if (this.notificationBuffer != null && !this.notificationBuffer.isEmpty()) {
                this.doRefreshFromNotifications(this.notificationBuffer);
            }
            this.notificationBuffer = null;
        } else if (propertyName == "IEditorModelManager.ecore.event") {
            if (this.notificationBuffer == null) {
                this.eCoreChanged((Notification)newValue);
            } else {
                this.notificationBuffer.add((Notification)newValue);
            }
        }
    }

    protected void eCoreChanged(Notification msg) {
        int type = msg.getEventType();
        if (type == 5 || type == 6 || type == 7 || type == 999 || type == 1000) {
            return;
        }
        try {
            this.getViewer().getControl().setRedraw(false);
            Set<EObject> elements = this.getElementsToUpdateFromNotification(msg);
            this.getViewer().update(elements.toArray(), null);
            EObject parent = this.getParentToRefreshFromNotification(msg);
            if (parent != null) {
                this.getViewer().refresh((Object)parent);
            }
        }
        finally {
            this.getViewer().getControl().setRedraw(true);
        }
    }

    protected void doRefreshFromNotifications(List<Notification> notifications) {
    }

    protected EObject getParentToRefreshFromNotification(Notification msg) {
        int type = msg.getEventType();
        EObject element = null;
        if (type == 4) {
            if (msg.getNotifier() instanceof EObject) {
                element = (EObject)msg.getNotifier();
                if (msg.getOldValue() instanceof IProperty && this.hasFormatExpression(element)) {
                    element = element.eContainer();
                }
            }
        } else if (type == 3) {
            if (msg.getNewValue() instanceof EObject) {
                element = ((EObject)msg.getNewValue()).eContainer();
                if (msg.getNewValue() instanceof IProperty && this.hasFormatExpression(element)) {
                    element = element.eContainer();
                }
            }
        } else if (type == 1 && msg.getNotifier() instanceof EObject) {
            element = (EObject)msg.getNotifier();
            if (msg.getFeature() == IArchimatePackage.Literals.NAMEABLE__NAME) {
                element = element.eContainer();
            } else if (this.hasFormatExpression(element)) {
                element = element.eContainer();
                if (msg.getNotifier() instanceof IProperty) {
                    element = element.eContainer();
                }
            }
        }
        return element instanceof IFolder ? element : null;
    }

    protected boolean hasFormatExpression(EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof IFolder && TextRenderer.getDefault().hasFormatExpression((IArchimateModelObject)((IFolder)eObject))) {
                return true;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    protected Set<EObject> getElementsToUpdateFromNotification(Notification msg) {
        HashSet<EObject> list = new HashSet<EObject>();
        if (msg.getNotifier() instanceof IFolder) {
            return list;
        }
        int type = msg.getEventType();
        EObject element = null;
        if (type == 4) {
            element = (EObject)msg.getOldValue();
        } else if (type == 3) {
            element = (EObject)msg.getNewValue();
        } else if (type == 1) {
            element = (EObject)msg.getNotifier();
        }
        if (element instanceof IDiagramModelContainer) {
            this.getDiagramElementsToUpdate(list, (IDiagramModelContainer)element);
            return list;
        }
        if (element instanceof IDiagramModelArchimateConnection) {
            element = ((IDiagramModelArchimateConnection)element).getArchimateRelationship();
        }
        if (element != null) {
            list.add(element);
            if (element instanceof IArchimateElement) {
                this.getRelationshipsToUpdate(list, (IArchimateElement)element);
            }
        }
        return list;
    }

    private void getDiagramElementsToUpdate(Set<EObject> list, IDiagramModelContainer container) {
        if (container instanceof IDiagramModelArchimateObject) {
            IArchimateElement element = ((IDiagramModelArchimateObject)container).getArchimateElement();
            list.add((EObject)element);
            this.getRelationshipsToUpdate(list, element);
        }
        for (IDiagramModelObject child : container.getChildren()) {
            if (!(child instanceof IDiagramModelContainer)) continue;
            this.getDiagramElementsToUpdate(list, (IDiagramModelContainer)child);
        }
    }

    private void getRelationshipsToUpdate(Set<EObject> list, IArchimateElement element) {
        for (IArchimateRelationship relation : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)element)) {
            list.add((EObject)relation);
        }
    }

    public void dispose() {
        super.dispose();
        IEditorModelManager.INSTANCE.removePropertyChangeListener(this);
        ArchiPlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.prefsListener);
        this.getSite().getShell().setText(ArchiPlugin.getInstance().getProductName());
    }
}

