/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.navigator;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.views.AbstractModelView;
import com.archimatetool.editor.views.navigator.INavigatorView;
import com.archimatetool.editor.views.navigator.Messages;
import com.archimatetool.editor.views.navigator.NavigatorViewer;
import com.archimatetool.editor.views.navigator.NavigatorViewerDragHandler;
import com.archimatetool.editor.views.tree.actions.IViewerAction;
import com.archimatetool.editor.views.tree.actions.PropertiesAction;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.DrillDownAdapter;

public class NavigatorView
extends AbstractModelView
implements INavigatorView,
ISelectionListener {
    private NavigatorViewer fTreeViewer;
    private IViewerAction fActionProperties;
    private IAction fActionNavDown;
    private IAction fActionNavUp;
    private IAction fActionPinContent;
    private NavigatorDrillDownAdapter fDrillDownAdapter;

    @Override
    public void doCreatePartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.fTreeViewer = new NavigatorViewer(parent, 0);
        this.fTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NavigatorView.this.fDrillDownAdapter.goInto();
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NavigatorView.this.updateActions();
            }
        });
        this.fDrillDownAdapter = new NavigatorDrillDownAdapter();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.makeActions();
        this.hookContextMenu();
        this.registerGlobalActions();
        this.makeLocalToolBar();
        this.updateActions();
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        new NavigatorViewerDragHandler((StructuredViewer)this.fTreeViewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.archimatetool.help.navigatorViewHelp");
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        this.selectionChanged(null, selection);
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    public NavigatorViewer getViewer() {
        return this.fTreeViewer;
    }

    private void makeActions() {
        this.fActionProperties = new PropertiesAction((ISelectionProvider)this.getViewer());
        this.fActionPinContent = new Action(Messages.NavigatorView_0, 2){
            {
                this.setToolTipText(Messages.NavigatorView_1);
                this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/pin.png"));
            }
        };
        this.fActionNavDown = new Action(Messages.NavigatorView_2, 8){
            {
                this.setToolTipText(Messages.NavigatorView_3);
                this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/nav-downward.png"));
                this.setChecked(true);
            }

            public void run() {
                NavigatorView.this.fActionNavUp.setChecked(false);
                NavigatorView.this.fTreeViewer.setShowTargetElements(true);
            }
        };
        this.fActionNavUp = new Action(Messages.NavigatorView_4, 8){
            {
                this.setToolTipText(Messages.NavigatorView_5);
                this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/nav-upward.png"));
            }

            public void run() {
                NavigatorView.this.fActionNavDown.setChecked(false);
                NavigatorView.this.fTreeViewer.setShowTargetElements(false);
            }
        };
    }

    private void registerGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fActionProperties);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#NavigatorViewPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NavigatorView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    private void fillContextMenu(IMenuManager manager) {
        boolean isEmpty;
        Object selected = ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
        boolean bl = isEmpty = selected == null;
        if (this.fDrillDownAdapter.canGoInto() || this.fDrillDownAdapter.canGoBack() || this.fDrillDownAdapter.canGoHome()) {
            this.fDrillDownAdapter.addNavigationActions(manager);
        }
        if (!isEmpty) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fActionProperties);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void updateActions() {
        this.fActionProperties.update();
        this.updateUndoActions();
    }

    private void makeLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionNavDown);
        manager.add(this.fActionNavUp);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionPinContent);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this || this.fActionPinContent.isChecked()) {
            return;
        }
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.setElement(((IStructuredSelection)selection).getFirstElement());
        }
    }

    @Override
    protected void selectAll() {
        this.fTreeViewer.getTree().selectAll();
    }

    private void setElement(Object object) {
        this.fDrillDownAdapter.reset();
        IArchimateConcept concept = null;
        if (object instanceof IArchimateConcept) {
            concept = (IArchimateConcept)object;
        } else if (object instanceof IAdaptable) {
            concept = (IArchimateConcept)((IAdaptable)object).getAdapter(IArchimateConcept.class);
        }
        this.getViewer().setInput(new Object[]{concept});
    }

    private void reset() {
        this.fDrillDownAdapter.reset();
        this.getViewer().setInput(null);
    }

    @Override
    protected IArchimateModel getActiveArchimateModel() {
        return this.getViewerInput() != null ? this.getViewerInput().getArchimateModel() : null;
    }

    private IArchimateModelObject getViewerInput() {
        return this.getViewer() != null && this.getViewer().getActualInput() != null ? this.getViewer().getActualInput() : null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.fTreeViewer = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "IEditorModelManager.model.removed") {
            if (this.getActiveArchimateModel() == evt.getNewValue()) {
                this.reset();
            }
        } else if (evt.getPropertyName() == "IEditorModelManager.model.dirty") {
            this.updateActions();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected void eCoreChanged(Notification msg) {
        this.doRefresh(msg);
    }

    @Override
    protected void doRefreshFromNotifications(List<Notification> notifications) {
        for (Notification msg : notifications) {
            if (this.doRefresh(msg)) break;
        }
    }

    private boolean doRefresh(Notification msg) {
        if (msg.getFeature() == IArchimatePackage.Literals.NAMEABLE__NAME) {
            this.getViewer().update(msg.getNotifier(), null);
        } else if (this.isRefreshEvent(msg)) {
            this.getViewer().refreshTreePreservingExpandedNodes();
            return true;
        }
        return false;
    }

    private boolean isRefreshEvent(Notification msg) {
        return msg.getNewValue() instanceof IArchimateConcept || msg.getOldValue() instanceof IArchimateConcept;
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"com.archimatetool.help.navigatorViewHelp");
    }

    public String getSearchExpression(Object target) {
        return Messages.NavigatorView_6;
    }

    private class NavigatorDrillDownAdapter
    extends DrillDownAdapter {
        public NavigatorDrillDownAdapter() {
            super((TreeViewer)NavigatorView.this.fTreeViewer);
        }

        public boolean canExpand(Object element) {
            return element != NavigatorView.this.getViewerInput();
        }

        public void goInto() {
            this.goInto(new Object[]{((IStructuredSelection)NavigatorView.this.fTreeViewer.getSelection()).getFirstElement()});
        }
    }
}

