/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.navigator;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class NavigatorViewer
extends TreeViewer {
    private boolean fShowTargetElements = true;

    public NavigatorViewer(Composite parent, int style) {
        super(parent, style | 2);
        ThemeUtils.registerCssId((Control)this.getTree(), "NavigatorTree");
        ThemeUtils.setFontIfCssThemingDisabled((Control)this.getTree(), "com.archimatetool.editor.NAVIGATOR_TREE_FONT");
        this.setContentProvider((IContentProvider)new NavigatorViewerContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new NavigatorViewerLabelProvider());
        this.setAutoExpandLevel(3);
        this.setUseHashlookup(true);
        this.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
    }

    IArchimateModelObject getActualInput() {
        Object input = this.getInput();
        if (input instanceof Object[] && ((Object[])input).length == 1) {
            input = ((Object[])input)[0];
        }
        return input instanceof IArchimateModelObject ? (IArchimateModelObject)input : null;
    }

    void setShowTargetElements(boolean set) {
        if (this.fShowTargetElements != set) {
            this.fShowTargetElements = set;
            this.refresh();
            this.expandToLevel(3);
        }
    }

    void refreshTreePreservingExpandedNodes() {
        try {
            Object[] expanded = this.getExpandedElements();
            this.getControl().setRedraw(false);
            this.refresh();
            this.setExpandedElements(expanded);
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    private class NavigatorViewerContentProvider
    implements ITreeContentProvider {
        private NavigatorViewerContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            IArchimateModelObject input;
            if (parent instanceof Object[] && (input = NavigatorViewer.this.getActualInput()) != null && input.eContainer() != null) {
                return (Object[])parent;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof IArchimateRelationship) {
                IArchimateRelationship relation = (IArchimateRelationship)parent;
                ArrayList<IArchimateConcept> results = new ArrayList<IArchimateConcept>();
                if (NavigatorViewer.this.fShowTargetElements) {
                    results.addAll((Collection<IArchimateConcept>)relation.getSourceRelationships());
                    results.add(relation.getTarget());
                } else {
                    results.addAll((Collection<IArchimateConcept>)relation.getTargetRelationships());
                    results.add(relation.getSource());
                }
                return results.toArray();
            }
            if (parent instanceof IArchimateElement) {
                IArchimateElement element = (IArchimateElement)parent;
                if (NavigatorViewer.this.fShowTargetElements) {
                    return element.getSourceRelationships().toArray();
                }
                return element.getTargetRelationships().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static class NavigatorViewerLabelProvider
    extends LabelProvider {
        private NavigatorViewerLabelProvider() {
        }

        public String getText(Object element) {
            return ArchiLabelProvider.INSTANCE.getLabelNormalised(element);
        }

        public Image getImage(Object element) {
            return ArchiLabelProvider.INSTANCE.getImage(element);
        }
    }
}

