/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree;

import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.views.tree.Messages;
import com.archimatetool.editor.views.tree.commands.MoveFolderCommand;
import com.archimatetool.editor.views.tree.commands.MoveObjectCommand;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IFolder;
import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TreeItem;

public class TreeModelViewerDragDropHandler {
    private StructuredViewer fViewer;
    private int fDragOperations = 3;
    private int fDropOperations = 2;
    private boolean fIsValidTreeSelection;
    Transfer[] sourceTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
    Transfer[] targetTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};

    public TreeModelViewerDragDropHandler(StructuredViewer viewer) {
        this.fViewer = viewer;
        this.registerDragSupport();
        this.registerDropSupport();
    }

    private void registerDragSupport() {
        this.fViewer.addDragSupport(this.fDragOperations, this.sourceTransferTypes, new DragSourceListener(){

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                TreeModelViewerDragDropHandler.this.fIsValidTreeSelection = false;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TreeModelViewerDragDropHandler.this.fViewer.getSelection();
                TreeModelViewerDragDropHandler.this.fIsValidTreeSelection = TreeModelViewerDragDropHandler.this.isValidTreeSelection(selection);
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                event.doit = true;
            }
        });
    }

    private void registerDropSupport() {
        this.fViewer.addDropSupport(this.fDropOperations, this.targetTransferTypes, new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
                if (event.detail == 0) {
                    event.feedback = 0;
                }
                event.feedback |= 0x18;
            }

            public void drop(DropTargetEvent event) {
                TreeModelViewerDragDropHandler.this.doDropOperation(event);
            }

            public void dropAccept(DropTargetEvent event) {
                event.detail = this.getEventDetail(event);
            }

            private int getEventDetail(DropTargetEvent event) {
                return TreeModelViewerDragDropHandler.this.isValidSelection(event) && TreeModelViewerDragDropHandler.this.isValidDropTarget(event) ? 2 : 0;
            }
        });
    }

    boolean isValidTreeSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        IArchimateModel model = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IArchimateModel) {
                return false;
            }
            if (object instanceof IFolder && ((IFolder)object).getType() != FolderType.USER) {
                return false;
            }
            if (object instanceof IArchimateModelObject) {
                IArchimateModel m = ((IArchimateModelObject)object).getArchimateModel();
                if (model != null && m != model) {
                    return false;
                }
                model = m;
            }
            ++n2;
        }
        return true;
    }

    boolean isValidSelection(DropTargetEvent event) {
        return this.fIsValidTreeSelection || this.isValidFileSelection(event);
    }

    boolean isValidFileSelection(DropTargetEvent event) {
        return this.isFileDragOperation(event.currentDataType);
    }

    void doDropOperation(DropTargetEvent event) {
        if (this.isLocalTreeDragOperation(event.currentDataType)) {
            Object parent = this.getTargetParent(event);
            if (parent instanceof IFolder) {
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                this.moveTreeObjects((IFolder)parent, selection.toArray());
            }
        } else if (this.isFileDragOperation(event.currentDataType)) {
            this.addFileObjects((String[])event.data);
        }
    }

    private void addFileObjects(final String[] paths) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    File file = new File(path);
                    if (file.getName().toLowerCase().endsWith(".archimate")) {
                        IEditorModelManager.INSTANCE.openModel(file);
                    }
                    ++n2;
                }
            }
        });
    }

    void moveTreeObjects(IFolder newParent, Object[] objects) {
        NonNotifyingCompoundCommand compoundCommand = new NonNotifyingCompoundCommand(){

            public String getLabel() {
                return this.getCommands().size() > 1 ? Messages.TreeModelViewerDragDropHandler_0 : super.getLabel();
            }
        };
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IFolder) {
                if (!newParent.getFolders().contains(object)) {
                    compoundCommand.add(new MoveFolderCommand(newParent, (IFolder)object));
                }
            } else if (object instanceof IArchimateModelObject && !newParent.getElements().contains(object)) {
                compoundCommand.add(new MoveObjectCommand(newParent, (IArchimateModelObject)object));
            }
            ++n2;
        }
        CommandStack stack = (CommandStack)newParent.getAdapter(CommandStack.class);
        stack.execute((Command)compoundCommand);
    }

    Object getTargetParent(DropTargetEvent event) {
        if (event.item == null) {
            return null;
        }
        Object objectDroppedOn = event.item.getData();
        if (objectDroppedOn instanceof IFolder) {
            return objectDroppedOn;
        }
        return null;
    }

    boolean isValidDropTarget(DropTargetEvent event) {
        if (this.isFileDragOperation(event.currentDataType)) {
            return event.item == null;
        }
        Object parent = this.getTargetParent(event);
        if (parent instanceof IFolder) {
            IFolder targetfolder = (IFolder)parent;
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            for (Object object : selection.toList()) {
                if (!this.hasCommonAncestorFolder((EObject)targetfolder, (EObject)object)) {
                    return false;
                }
                if (this.canDropObject(object, (TreeItem)event.item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean hasCommonAncestorFolder(EObject eObject1, EObject eObject2) {
        while (eObject1.eContainer() instanceof IFolder) {
            eObject1 = eObject1.eContainer();
        }
        while (eObject2.eContainer() instanceof IFolder) {
            eObject2 = eObject2.eContainer();
        }
        return eObject1 == eObject2;
    }

    boolean canDropObject(Object object, TreeItem targetTreeItem) {
        if (targetTreeItem == null) {
            return false;
        }
        if (object == targetTreeItem.getData()) {
            return false;
        }
        if (object instanceof IFolder) {
            while ((targetTreeItem = targetTreeItem.getParentItem()) != null) {
                if (targetTreeItem.getData() != object) continue;
                return false;
            }
        }
        return true;
    }

    boolean isLocalTreeDragOperation(TransferData dataType) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(dataType);
    }

    boolean isFileDragOperation(TransferData dataType) {
        return FileTransfer.getInstance().isSupportedType(dataType);
    }
}

