/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.actions;

import com.archimatetool.editor.views.tree.ITreeModelView;
import com.archimatetool.editor.views.tree.actions.TreeModelViewActionFactory;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class NewMenuContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    private MenuManager menuManager;
    private ISelectionService selectionService;
    private IPartService partService;

    public void fill(Menu menu, int index) {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        Object selected = null;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection != null) {
            selected = selection.getFirstElement();
        }
        if (selected == null) {
            selected = this.getTreeInput();
        }
        if (selected == null) {
            return;
        }
        List<IAction> actions = TreeModelViewActionFactory.INSTANCE.getNewObjectActions(selected);
        this.menuManager = new MenuManager();
        for (IAction action : actions) {
            if (action != null) {
                this.menuManager.add(action);
                continue;
            }
            this.menuManager.add((IContributionItem)new Separator());
        }
        this.setVisible(!actions.isEmpty());
        IContributionItem[] iContributionItemArray = this.menuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.fill(menu, index++);
            ++n2;
        }
    }

    public boolean isDynamic() {
        return true;
    }

    private Object getTreeInput() {
        if (this.partService.getActivePart() instanceof ITreeModelView) {
            return ((ITreeModelView)this.partService.getActivePart()).getViewer().getInput();
        }
        return null;
    }

    private IStructuredSelection getCurrentSelection() {
        return (IStructuredSelection)this.selectionService.getSelection("com.archimatetool.editor.treeModelView");
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.selectionService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        this.partService = (IPartService)serviceLocator.getService(IPartService.class);
    }
}

