/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.actions;

import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.ui.LocalClipboard;
import com.archimatetool.editor.views.tree.TreeModelCutAndPaste;
import com.archimatetool.editor.views.tree.actions.Messages;
import com.archimatetool.editor.views.tree.actions.ViewerAction;
import com.archimatetool.editor.views.tree.commands.MoveFolderCommand;
import com.archimatetool.editor.views.tree.commands.MoveObjectCommand;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IFolder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class PasteAction
extends ViewerAction {
    public PasteAction(ISelectionProvider selectionProvider) {
        super(selectionProvider);
        this.setText(Messages.PasteAction_0);
        this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setEnabled(false);
        LocalClipboard.getDefault().addListener(clipboardContents -> this.update());
    }

    public void run() {
        if (!this.hasValidSelection()) {
            this.setEnabled(false);
            return;
        }
        IFolder parent = (IFolder)this.getSelection().getFirstElement();
        NonNotifyingCompoundCommand compoundCommand = new NonNotifyingCompoundCommand(){

            public String getLabel() {
                return this.getCommands().size() > 1 ? Messages.PasteAction_1 : super.getLabel();
            }
        };
        for (IArchimateModelObject selected : TreeModelCutAndPaste.INSTANCE.getObjects()) {
            if (!this.isAllowedToPaste(parent, selected)) continue;
            if (selected instanceof IFolder) {
                compoundCommand.add(new MoveFolderCommand(parent, (IFolder)selected));
                continue;
            }
            compoundCommand.add(new MoveObjectCommand(parent, selected));
        }
        CommandStack commandStack = (CommandStack)parent.getAdapter(CommandStack.class);
        if (commandStack != null) {
            commandStack.execute((Command)compoundCommand);
            TreeModelCutAndPaste.INSTANCE.clear();
            ((TreeViewer)this.getSelectionProvider()).expandToLevel((Object)parent, 1);
        }
    }

    @Override
    public void update() {
        if (!this.hasValidSelection()) {
            this.setEnabled(false);
            return;
        }
        IFolder parent = (IFolder)this.getSelection().getFirstElement();
        for (IArchimateModelObject object : TreeModelCutAndPaste.INSTANCE.getObjects()) {
            if (!this.isAllowedToPaste(parent, object)) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    private boolean hasValidSelection() {
        return TreeModelCutAndPaste.INSTANCE.hasContents() && this.getSelection() != null && !this.getSelection().isEmpty() && this.getSelection().getFirstElement() instanceof IFolder;
    }

    private boolean isAllowedToPaste(IFolder parent, IArchimateModelObject object) {
        boolean result = true;
        if (object instanceof IFolder) {
            result = this.isFolderAncestor(parent, (IFolder)object);
        }
        return result && object.getArchimateModel() != null && object.getArchimateModel() == parent.getArchimateModel() && object.eContainer() != parent && this.hasCommonAncestorFolder((EObject)parent, (EObject)object);
    }

    private boolean isFolderAncestor(IFolder targetFolder, IFolder cutFolder) {
        IFolder eObject = targetFolder;
        while (eObject instanceof IFolder) {
            if (eObject == cutFolder) {
                return false;
            }
            eObject = eObject.eContainer();
        }
        return true;
    }

    private boolean hasCommonAncestorFolder(EObject eObject1, EObject eObject2) {
        while (eObject1.eContainer() instanceof IFolder) {
            eObject1 = eObject1.eContainer();
        }
        while (eObject2.eContainer() instanceof IFolder) {
            eObject2 = eObject2.eContainer();
        }
        return eObject1 == eObject2;
    }
}

