/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.actions;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.editor.views.tree.actions.Messages;
import com.archimatetool.editor.views.tree.commands.NewDiagramCommand;
import com.archimatetool.editor.views.tree.commands.NewElementCommand;
import com.archimatetool.editor.views.tree.commands.NewFolderCommand;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.ISketchModel;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public class TreeModelViewActionFactory {
    public static final TreeModelViewActionFactory INSTANCE = new TreeModelViewActionFactory();

    private TreeModelViewActionFactory() {
    }

    public List<IAction> getNewObjectActions(Object selected) {
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        if (selected instanceof IArchimateConcept || selected instanceof IDiagramModel) {
            selected = ((EObject)selected).eContainer();
        }
        if (!(selected instanceof IFolder)) {
            return actionList;
        }
        IFolder selectedFolder = (IFolder)selected;
        actionList.add(this.createNewFolderAction((IFolder)selected));
        actionList.add(null);
        IFolder topMostFolder = selectedFolder;
        while (topMostFolder.eContainer() instanceof IFolder) {
            topMostFolder = (IFolder)topMostFolder.eContainer();
        }
        switch (topMostFolder.getType()) {
            case STRATEGY: {
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getStrategyClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getStrategyClasses(), selectedFolder));
                break;
            }
            case BUSINESS: {
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getBusinessClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getBusinessClasses(), selectedFolder));
                break;
            }
            case APPLICATION: {
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getApplicationClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getApplicationClasses(), selectedFolder));
                break;
            }
            case MOTIVATION: {
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getMotivationClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getMotivationClasses(), selectedFolder));
                break;
            }
            case IMPLEMENTATION_MIGRATION: {
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getImplementationMigrationClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getImplementationMigrationClasses(), selectedFolder));
                break;
            }
            case TECHNOLOGY: {
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getTechnologyClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getPhysicalClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getPhysicalClasses(), selectedFolder));
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getTechnologyClasses(), selectedFolder));
                break;
            }
            case OTHER: {
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getOtherClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createConceptActions(ArchimateModelUtils.getConnectorClasses(), selectedFolder));
                actionList.add(null);
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getOtherClasses(), selectedFolder));
                actionList.addAll(this.createSpecializationActions(ArchimateModelUtils.getConnectorClasses(), selectedFolder));
                break;
            }
            case DIAGRAMS: {
                actionList.add(this.createNewArchimateDiagramAction(selectedFolder));
                actionList.add(this.createNewSketchAction(selectedFolder));
                break;
            }
        }
        if (actionList.get(actionList.size() - 1) == null) {
            actionList.remove(actionList.size() - 1);
        }
        return actionList;
    }

    private List<IAction> createConceptActions(EClass[] classes, IFolder folder) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        EClass[] eClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            IAction action = this.createNewElementAction(folder, eClass);
            actions.add(action);
            ++n2;
        }
        return actions;
    }

    private List<IAction> createSpecializationActions(EClass[] classes, IFolder folder) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("showSpecializationsInModelTree") || folder.getArchimateModel().getProfiles().isEmpty()) {
            return actions;
        }
        ArrayList profiles = new ArrayList(folder.getArchimateModel().getProfiles());
        Collator collator = Collator.getInstance();
        profiles.sort((p1, p2) -> collator.compare(p1.getName(), p2.getName()));
        Set<EClass> classesSet = Set.of(classes);
        for (IProfile profile : profiles) {
            if (!classesSet.contains(profile.getConceptClass())) continue;
            IAction action = this.createNewSpecializationAction(folder, profile);
            actions.add(action);
        }
        return actions;
    }

    private IAction createNewElementAction(final IFolder folder, final EClass eClass) {
        Action action = new Action(ArchiLabelProvider.INSTANCE.getDefaultName(eClass)){

            public void run() {
                IArchimateElement element = (IArchimateElement)IArchimateFactory.eINSTANCE.create(eClass);
                element.setName(this.getText());
                NewElementCommand cmd = new NewElementCommand(folder, element);
                CommandStack commandStack = (CommandStack)folder.getAdapter(CommandStack.class);
                commandStack.execute((Command)cmd);
            }
        };
        action.setImageDescriptor(ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass));
        return action;
    }

    private IAction createNewSpecializationAction(final IFolder folder, final IProfile profile) {
        Action action = new Action(profile.getName()){

            public void run() {
                IArchimateElement element = (IArchimateElement)IArchimateFactory.eINSTANCE.create(profile.getConceptClass());
                element.setName(profile.getName());
                element.getProfiles().add((Object)profile);
                NewElementCommand cmd = new NewElementCommand(folder, element);
                CommandStack commandStack = (CommandStack)folder.getAdapter(CommandStack.class);
                commandStack.execute((Command)cmd);
            }
        };
        action.setImageDescriptor(profile.getImagePath() != null ? ArchiLabelProvider.INSTANCE.getImageDescriptorForSpecialization(profile) : ArchiLabelProvider.INSTANCE.getImageDescriptor(profile.getConceptClass()));
        return action;
    }

    private IAction createNewArchimateDiagramAction(final IFolder folder) {
        Action action = new Action(Messages.TreeModelViewActionFactory_0){

            public void run() {
                IArchimateDiagramModel diagramModel = IArchimateFactory.eINSTANCE.createArchimateDiagramModel();
                diagramModel.setName(Messages.TreeModelViewActionFactory_1);
                NewDiagramCommand cmd = new NewDiagramCommand(folder, (IDiagramModel)diagramModel, Messages.TreeModelViewActionFactory_1);
                CommandStack commandStack = (CommandStack)folder.getAdapter(CommandStack.class);
                commandStack.execute((Command)cmd);
            }
        };
        action.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/diagram.png"));
        return action;
    }

    private IAction createNewSketchAction(final IFolder folder) {
        Action action = new Action(Messages.TreeModelViewActionFactory_2){

            public void run() {
                ISketchModel sketchModel = IArchimateFactory.eINSTANCE.createSketchModel();
                sketchModel.setName(Messages.TreeModelViewActionFactory_3);
                int defaultBackground = ArchiPlugin.getInstance().getPreferenceStore().getInt("sketchDefaultBackground");
                sketchModel.setBackground(defaultBackground);
                NewDiagramCommand cmd = new NewDiagramCommand(folder, (IDiagramModel)sketchModel, Messages.TreeModelViewActionFactory_3);
                CommandStack commandStack = (CommandStack)folder.getAdapter(CommandStack.class);
                commandStack.execute((Command)cmd);
            }
        };
        action.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/sketch.png"));
        return action;
    }

    private IAction createNewFolderAction(final IFolder folder) {
        Action action = new Action(Messages.NewFolderAction_0){

            public void run() {
                IFolder newFolder = IArchimateFactory.eINSTANCE.createFolder();
                newFolder.setName(Messages.NewFolderAction_1);
                newFolder.setType(FolderType.USER);
                NewFolderCommand cmd = new NewFolderCommand(folder, newFolder);
                CommandStack commandStack = (CommandStack)folder.getAdapter(CommandStack.class);
                commandStack.execute((Command)cmd);
            }
        };
        IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)folder);
        action.setImageDescriptor(provider.getImageDescriptor());
        return action;
    }
}

