/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.diagram.commands.DiagramCommandFactory;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.model.commands.DeleteArchimateElementCommand;
import com.archimatetool.editor.model.commands.DeleteArchimateRelationshipCommand;
import com.archimatetool.editor.model.commands.DeleteDiagramModelCommand;
import com.archimatetool.editor.model.commands.DeleteFolderCommand;
import com.archimatetool.editor.views.tree.TreeModelViewer;
import com.archimatetool.editor.views.tree.commands.DeleteElementsCompoundCommand;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IAdapter;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DeleteCommandHandler {
    private Hashtable<CommandStack, CompoundCommand> fCommandMap = new Hashtable();
    private TreeModelViewer fViewer;
    private Object[] fSelectedObjects = new Object[1];
    private Set<IArchimateModelObject> fObjectsToDelete;
    private Object fObjectToSelectAfterDeletion;
    private Map<IArchimateModel, List<IDiagramModelReference>> fDiagramModelReferenceCache;

    public static boolean canDelete(Object element) {
        IFolder folder;
        return element instanceof IArchimateConcept || element instanceof IDiagramModel || element instanceof IFolder && (folder = (IFolder)element).getType().equals((Object)FolderType.USER);
    }

    public DeleteCommandHandler(Object[] objects) {
        this(null, objects);
    }

    public DeleteCommandHandler(TreeModelViewer viewer, Object[] objects) {
        this.fViewer = viewer;
        this.fSelectedObjects = objects;
    }

    public boolean hasDiagramReferences() {
        Object[] objectArray = this.fSelectedObjects;
        int n = this.fSelectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (this.hasDiagramReferences(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasDiagramReferences(Object object) {
        if (object instanceof IFolder) {
            IFolder folder = (IFolder)object;
            for (EObject element : folder.getElements()) {
                if (!this.hasDiagramReferences(element)) continue;
                return true;
            }
            for (IFolder subFolder : folder.getFolders()) {
                if (!this.hasDiagramReferences(subFolder)) continue;
                return true;
            }
        }
        if (object instanceof IArchimateConcept) {
            IArchimateConcept concept = (IArchimateConcept)object;
            return DiagramModelUtils.isArchimateConceptReferencedInDiagrams(concept);
        }
        if (object instanceof IDiagramModel) {
            IDiagramModel dm = (IDiagramModel)object;
            return DiagramModelUtils.hasDiagramModelReference(dm);
        }
        return false;
    }

    public void delete() {
        this.fObjectToSelectAfterDeletion = this.findObjectToSelectAfterDeletion();
        this.fObjectsToDelete = new HashSet<IArchimateModelObject>();
        this.fDiagramModelReferenceCache = new HashMap<IArchimateModel, List<IDiagramModelReference>>();
        this.getObjectsToDelete();
        this.createCommands();
        for (Map.Entry<CommandStack, CompoundCommand> entry : this.fCommandMap.entrySet()) {
            entry.getKey().execute((Command)entry.getValue());
        }
        this.dispose();
    }

    private void createCommands() {
        Command cmd;
        for (IArchimateModelObject object : this.fObjectsToDelete) {
            if (!(object instanceof IDiagramModel)) continue;
            IDiagramModel dm = (IDiagramModel)object;
            CompoundCommand compoundCommand = this.getCompoundCommand((IAdapter)dm);
            if (compoundCommand != null) {
                cmd = new DeleteDiagramModelCommand(dm);
                compoundCommand.add(cmd);
                continue;
            }
            System.err.println("Could not get CompoundCommand in " + String.valueOf(this.getClass()));
        }
        for (IArchimateModelObject object : this.fObjectsToDelete) {
            if (object instanceof IDiagramModel) continue;
            CompoundCommand compoundCommand = this.getCompoundCommand((IAdapter)object);
            if (compoundCommand == null) {
                System.err.println("Could not get CompoundCommand in " + String.valueOf(this.getClass()));
                continue;
            }
            if (object instanceof IFolder) {
                IFolder folder = (IFolder)object;
                cmd = new DeleteFolderCommand(folder);
                compoundCommand.add(cmd);
                continue;
            }
            if (object instanceof IArchimateElement) {
                IArchimateElement element = (IArchimateElement)object;
                DeleteArchimateElementCommand cmd2 = new DeleteArchimateElementCommand(element);
                compoundCommand.add((Command)cmd2);
                continue;
            }
            if (object instanceof IArchimateRelationship) {
                IArchimateRelationship relationship = (IArchimateRelationship)object;
                DeleteArchimateRelationshipCommand cmd3 = new DeleteArchimateRelationshipCommand(relationship);
                compoundCommand.add((Command)cmd3);
                continue;
            }
            if (object instanceof IDiagramModelObject) {
                IDiagramModelObject dmo = (IDiagramModelObject)object;
                Command cmd4 = DiagramCommandFactory.createDeleteDiagramObjectCommand(dmo);
                compoundCommand.add(cmd4);
                continue;
            }
            if (!(object instanceof IDiagramModelConnection)) continue;
            IDiagramModelConnection dmc = (IDiagramModelConnection)object;
            Command cmd5 = DiagramCommandFactory.createDeleteDiagramConnectionCommand(dmc);
            compoundCommand.add(cmd5);
        }
    }

    private void getObjectsToDelete() {
        Object[] objectArray = this.fSelectedObjects;
        int n = this.fSelectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (DeleteCommandHandler.canDelete(object)) {
                this.fObjectsToDelete.add((IArchimateModelObject)object);
                this.addFolderChildElements(object);
                this.addElementRelationships(object);
            }
            ++n2;
        }
        for (IArchimateModelObject iArchimateModelObject : new ArrayList<IArchimateModelObject>(this.fObjectsToDelete)) {
            if (iArchimateModelObject instanceof IArchimateConcept) {
                IArchimateConcept concept = (IArchimateConcept)iArchimateModelObject;
                this.fObjectsToDelete.addAll(concept.getReferencingDiagramComponents());
            }
            if (!(iArchimateModelObject instanceof IDiagramModel)) continue;
            IDiagramModel dm = (IDiagramModel)iArchimateModelObject;
            this.getDiagramModelReferencesToDelete(dm);
        }
    }

    private void getDiagramModelReferencesToDelete(IDiagramModel dm) {
        List<IDiagramModelReference> refs = this.fDiagramModelReferenceCache.get(dm.getArchimateModel());
        if (refs == null) {
            refs = new ArrayList<IDiagramModelReference>();
            IFolder diagramsFolder = dm.getArchimateModel().getFolder(FolderType.DIAGRAMS);
            if (diagramsFolder != null) {
                TreeIterator iter = diagramsFolder.eAllContents();
                while (iter.hasNext()) {
                    EObject eObject = (EObject)iter.next();
                    if (!(eObject instanceof IDiagramModelReference)) continue;
                    IDiagramModelReference ref = (IDiagramModelReference)eObject;
                    refs.add(ref);
                }
            }
            this.fDiagramModelReferenceCache.put(dm.getArchimateModel(), refs);
        }
        for (IDiagramModelReference ref : refs) {
            if (ref.getReferencedModel() != dm) continue;
            this.fObjectsToDelete.add((IArchimateModelObject)ref);
        }
    }

    private void addFolderChildElements(Object object) {
        if (object instanceof IFolder) {
            IFolder folder = (IFolder)object;
            for (EObject element : folder.getElements()) {
                this.addFolderChildElements(element);
            }
            for (IFolder childFolder : folder.getFolders()) {
                this.addFolderChildElements(childFolder);
            }
        } else if (object instanceof IArchimateModelObject) {
            IArchimateModelObject amo = (IArchimateModelObject)object;
            this.fObjectsToDelete.add(amo);
        }
    }

    private void addElementRelationships(Object object) {
        block4: {
            block3: {
                if (!(object instanceof IFolder)) break block3;
                IFolder folder = (IFolder)object;
                for (EObject element : folder.getElements()) {
                    this.addElementRelationships(element);
                }
                for (IFolder childFolder : folder.getFolders()) {
                    this.addElementRelationships(childFolder);
                }
                break block4;
            }
            if (!(object instanceof IArchimateConcept)) break block4;
            IArchimateConcept concept = (IArchimateConcept)object;
            for (IArchimateRelationship relationship : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)concept)) {
                this.fObjectsToDelete.add((IArchimateModelObject)relationship);
                this.addElementRelationships(relationship);
            }
        }
    }

    private CompoundCommand getCompoundCommand(IAdapter object) {
        CommandStack stack = (CommandStack)object.getAdapter(CommandStack.class);
        if (stack == null) {
            System.err.println("CommandStack was null in " + String.valueOf(this.getClass()));
            return null;
        }
        CompoundCommand compoundCommand = this.fCommandMap.get(stack);
        if (compoundCommand == null) {
            compoundCommand = new DeleteElementsCompoundCommand(this.fObjectToSelectAfterDeletion);
            this.fCommandMap.put(stack, compoundCommand);
        }
        return compoundCommand;
    }

    private Object findObjectToSelectAfterDeletion() {
        if (this.fViewer == null) {
            return null;
        }
        Object firstObject = this.fSelectedObjects[0];
        TreeItem item = this.fViewer.findTreeItem(firstObject);
        if (item == null) {
            return null;
        }
        TreeItem parentTreeItem = item.getParentItem();
        if (parentTreeItem == null) {
            Tree tree = item.getParent();
            int index = tree.indexOf(item);
            if (index < 1) {
                return null;
            }
            return tree.getItem(index - 1).getData();
        }
        Object selected = null;
        int index = parentTreeItem.indexOf(item);
        if (index > 0) {
            selected = parentTreeItem.getItem(index - 1).getData();
        }
        if (selected == null && firstObject instanceof EObject) {
            EObject eObject = (EObject)firstObject;
            selected = eObject.eContainer();
        }
        return selected;
    }

    private void dispose() {
        this.fSelectedObjects = null;
        this.fObjectsToDelete = null;
        this.fViewer = null;
        this.fCommandMap = null;
        this.fDiagramModelReferenceCache = null;
        this.fObjectToSelectAfterDeletion = null;
    }
}

