/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.ui.services.EditorManager;
import com.archimatetool.editor.ui.services.UIRequestManager;
import com.archimatetool.editor.views.tree.TreeSelectionRequest;
import com.archimatetool.editor.views.tree.commands.Messages;
import com.archimatetool.model.IAdapter;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.util.UUIDFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DuplicateCommandHandler {
    private Hashtable<CommandStack, CompoundCommand> fCommandMap = new Hashtable();
    private Object[] fSelectedObjects;
    private List<Object> fNewObjects = new ArrayList<Object>();
    private boolean doOpenDiagrams = true;

    public static boolean canDuplicate(IStructuredSelection selection) {
        for (Object element : selection.toList()) {
            if (!DuplicateCommandHandler.canDuplicate(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean canDuplicate(Object element) {
        return element instanceof IArchimateElement || element instanceof IDiagramModel;
    }

    public DuplicateCommandHandler(Object[] objects) {
        this.fSelectedObjects = objects;
    }

    public void duplicate() {
        this.createCommands();
        for (Map.Entry<CommandStack, CompoundCommand> entry : this.fCommandMap.entrySet()) {
            entry.getKey().execute((Command)entry.getValue());
        }
        UIRequestManager.INSTANCE.fireRequestAsync(new TreeSelectionRequest((Object)this, (IStructuredSelection)new StructuredSelection(this.fNewObjects), true));
        this.dispose();
    }

    private void createCommands() {
        Object[] objectArray = this.fSelectedObjects;
        int n = this.fSelectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (DuplicateCommandHandler.canDuplicate(object)) {
                CompoundCommand compoundCommand = this.getCompoundCommand((IAdapter)object);
                if (compoundCommand == null) {
                    System.err.println("Could not get CompoundCommand in " + String.valueOf(this.getClass()));
                } else if (object instanceof IDiagramModel) {
                    cmd = new DuplicateDiagramModelCommand((IDiagramModel)object);
                    compoundCommand.add(cmd);
                } else if (object instanceof IArchimateElement) {
                    cmd = new DuplicateElementCommand((IArchimateElement)object);
                    compoundCommand.add(cmd);
                }
            }
            ++n2;
        }
    }

    private CompoundCommand getCompoundCommand(IAdapter object) {
        CommandStack stack = (CommandStack)object.getAdapter(CommandStack.class);
        if (stack == null) {
            System.err.println("CommandStack was null in " + String.valueOf(this.getClass()));
            return null;
        }
        CompoundCommand compoundCommand = this.fCommandMap.get(stack);
        if (compoundCommand == null) {
            compoundCommand = new NonNotifyingCompoundCommand(Messages.DuplicateCommandHandler_1);
            this.fCommandMap.put(stack, compoundCommand);
        }
        return compoundCommand;
    }

    private void dispose() {
        this.fSelectedObjects = null;
        this.fCommandMap = null;
        this.fNewObjects = null;
    }

    private class DuplicateDiagramModelCommand
    extends Command {
        private IFolder fParent;
        private IDiagramModel fDiagramModelOriginal;
        private IDiagramModel fDiagramModelCopy;

        private DuplicateDiagramModelCommand(IDiagramModel dm) {
            this.fParent = (IFolder)dm.eContainer();
            this.fDiagramModelOriginal = dm;
            this.setLabel(Messages.DuplicateCommandHandler_2);
        }

        public void execute() {
            this.fDiagramModelCopy = (IDiagramModel)EcoreUtil.copy((EObject)this.fDiagramModelOriginal);
            UUIDFactory.generateNewIDs((EObject)this.fDiagramModelCopy);
            this.fDiagramModelCopy.setName(this.fDiagramModelOriginal.getName() + " " + Messages.DuplicateCommandHandler_3);
            this.fParent.getElements().add((Object)this.fDiagramModelCopy);
            DuplicateCommandHandler.this.fNewObjects.add(this.fDiagramModelCopy);
            if (DuplicateCommandHandler.this.doOpenDiagrams) {
                EditorManager.openDiagramEditor(this.fDiagramModelCopy, false);
            }
        }

        public void undo() {
            EditorManager.closeDiagramEditor(this.fDiagramModelCopy);
            this.fParent.getElements().remove((Object)this.fDiagramModelCopy);
        }

        public void redo() {
            this.fParent.getElements().add((Object)this.fDiagramModelCopy);
            if (DuplicateCommandHandler.this.doOpenDiagrams) {
                EditorManager.openDiagramEditor(this.fDiagramModelCopy, false);
            }
        }

        public void dispose() {
            this.fParent = null;
            this.fDiagramModelOriginal = null;
            this.fDiagramModelCopy = null;
        }
    }

    private class DuplicateElementCommand
    extends Command {
        private IFolder fParent;
        private IArchimateElement fElementCopy;

        private DuplicateElementCommand(IArchimateElement element) {
            this.setLabel(Messages.DuplicateCommandHandler_4);
            this.fParent = (IFolder)element.eContainer();
            this.fElementCopy = (IArchimateElement)element.getCopy();
            this.fElementCopy.setName(element.getName() + " " + Messages.DuplicateCommandHandler_3);
            DuplicateCommandHandler.this.fNewObjects.add(this.fElementCopy);
        }

        public void execute() {
            this.fParent.getElements().add((Object)this.fElementCopy);
        }

        public void undo() {
            this.fParent.getElements().remove((Object)this.fElementCopy);
        }

        public void dispose() {
            this.fParent = null;
            this.fElementCopy = null;
        }
    }
}

