/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.commands;

import com.archimatetool.editor.ui.services.UIRequestManager;
import com.archimatetool.editor.views.tree.TreeEditElementRequest;
import com.archimatetool.editor.views.tree.TreeSelectionRequest;
import com.archimatetool.editor.views.tree.commands.Messages;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IFolder;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class NewElementCommand
extends Command {
    private IFolder fFolder;
    private IArchimateElement fElement;

    public NewElementCommand(IFolder folder, IArchimateElement element) {
        this.fFolder = folder;
        this.fElement = element;
        this.setLabel(Messages.NewElementCommand_0);
    }

    public void execute() {
        this.redo();
        UIRequestManager.INSTANCE.fireRequest(new TreeEditElementRequest((Object)this, this.fElement));
    }

    public void undo() {
        this.fFolder.getElements().remove((Object)this.fElement);
        TreeSelectionRequest request = new TreeSelectionRequest((Object)this, (IStructuredSelection)new StructuredSelection((Object)this.fFolder), true){

            @Override
            public boolean shouldSelect(Viewer viewer) {
                return viewer.getSelection().isEmpty();
            }
        };
        UIRequestManager.INSTANCE.fireRequest(request);
    }

    public void redo() {
        this.fFolder.getElements().add((Object)this.fElement);
        UIRequestManager.INSTANCE.fireRequest(new TreeSelectionRequest((Object)this, (IStructuredSelection)new StructuredSelection((Object)this.fElement), true));
    }
}

