/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.views.tree.search;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.actions.AbstractDropDownAction;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.ui.components.GlobalActionDisablementHandler;
import com.archimatetool.editor.ui.dialog.UserPropertiesKeySelectionDialog;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.editor.views.tree.search.Messages;
import com.archimatetool.editor.views.tree.search.SearchFilter;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SearchWidget
extends Composite {
    private Text fSearchText;
    private SearchFilter fSearchFilter;
    private TreeViewer fViewer;
    private Set<Object> fExpandedTreeObjects;
    private IAction fActionFilterName;
    private IAction fActionFilterDocumentation;
    private IAction fActionFilterPropertyValues;
    private IAction fActionFilterViews;
    private IAction fActionShowAllFolders;
    private IAction fActionMatchCase;
    private IAction fActionUseRegex;
    private List<IAction> fConceptActions = new ArrayList<IAction>();
    private MenuManager fSpecializationsMenu;
    private Timer fKeyDelayTimer;
    private static int TIMER_DELAY = 600;
    private static final Color ERROR_COLOR = new Color(255, 0, 0);
    private static final String ERROR_COLOR_CSS = "color: RGB(255, 0, 0);";
    private Listener textControlListener = new Listener(){
        private GlobalActionDisablementHandler globalActionHandler;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    this.globalActionHandler = new GlobalActionDisablementHandler();
                    this.globalActionHandler.clearGlobalActions();
                    break;
                }
                case 27: {
                    if (this.globalActionHandler == null) break;
                    this.globalActionHandler.restoreGlobalActions();
                    break;
                }
            }
        }
    };
    private ITreeViewerListener treeExpansionListener = new ITreeViewerListener(){

        public void treeExpanded(TreeExpansionEvent event) {
            SearchWidget.this.fExpandedTreeObjects.add(event.getElement());
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            SearchWidget.this.fExpandedTreeObjects.remove(event.getElement());
        }
    };

    public SearchWidget(TreeViewer viewer) {
        super(viewer.getTree().getParent(), 0);
        this.fViewer = viewer;
        this.saveTreeState();
        this.fSearchFilter = new SearchFilter();
        this.fViewer.addFilter((ViewerFilter)this.fSearchFilter);
        this.fViewer.addTreeListener(this.treeExpansionListener);
        GridLayout layout = new GridLayout(2, false);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        this.createToolBar();
        this.createSearchTextWidget();
    }

    public boolean setFocus() {
        return this.fSearchText.isDisposed() ? false : this.fSearchText.setFocus();
    }

    private void createSearchTextWidget() {
        this.fSearchText = UIUtils.createSingleTextControl(this, 896, false);
        this.fSearchText.setLayoutData((Object)new GridData(768));
        UIUtils.applyMacCancelIconListener(this.fSearchText);
        UIUtils.applyMacUndoBugFilter((Control)this.fSearchText);
        if (ArchiPlugin.getInstance().getPreferenceStore().getBoolean("treeSearchAuto")) {
            this.fSearchText.addModifyListener(event -> {
                if (this.fKeyDelayTimer != null) {
                    this.fKeyDelayTimer.cancel();
                }
                this.fKeyDelayTimer = new Timer();
                this.fKeyDelayTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().syncExec(() -> SearchWidget.this.updateSearch());
                    }
                }, TIMER_DELAY);
            });
        } else {
            this.fSearchText.addListener(14, event -> this.updateSearch());
        }
        this.fSearchText.addListener(26, this.textControlListener);
        this.fSearchText.addListener(27, this.textControlListener);
    }

    private void updateSearch() {
        if (!this.fSearchText.isDisposed()) {
            this.fSearchFilter.setSearchText(this.fSearchText.getText());
            this.setValidSearchTextHint();
            this.refreshTree();
        }
    }

    private void setValidSearchTextHint() {
        String cssColor;
        boolean validSearchText = this.fSearchFilter.isValidSearchString();
        String string = cssColor = validSearchText ? null : ERROR_COLOR_CSS;
        if (!Objects.equals(this.fSearchText.getData("style"), cssColor)) {
            this.fSearchText.setForeground(validSearchText ? null : ERROR_COLOR);
            this.fSearchText.setData("style", (Object)cssColor);
            this.fSearchText.reskin(0);
        }
        this.fSearchText.setToolTipText(validSearchText ? null : Messages.SearchWidget_20);
    }

    private void createToolBar() {
        ToolBarManager toolBarmanager = new ToolBarManager(0x800000);
        toolBarmanager.createControl((Composite)this);
        AbstractDropDownAction dropDownAction = new AbstractDropDownAction(Messages.SearchWidget_4){

            public ImageDescriptor getImageDescriptor() {
                return IArchiImages.ImageFactory.getImageDescriptor("img/filter.png");
            }
        };
        toolBarmanager.add((IAction)dropDownAction);
        this.fActionFilterName = new Action(Messages.SearchWidget_0, 2){

            public void run() {
                SearchWidget.this.fSearchFilter.setFilterOnName(this.isChecked());
                SearchWidget.this.refreshTree();
            }
        };
        this.fActionFilterName.setToolTipText(Messages.SearchWidget_1);
        dropDownAction.add(this.fActionFilterName);
        this.fActionFilterDocumentation = new Action(Messages.SearchWidget_2, 2){

            public void run() {
                SearchWidget.this.fSearchFilter.setFilterOnDocumentation(this.isChecked());
                SearchWidget.this.refreshTree();
            }
        };
        this.fActionFilterDocumentation.setToolTipText(Messages.SearchWidget_3);
        dropDownAction.add(this.fActionFilterDocumentation);
        this.fActionFilterPropertyValues = new Action(Messages.SearchWidget_21, 2){

            public void run() {
                SearchWidget.this.fSearchFilter.setFilterOnPropertyValues(this.isChecked());
                SearchWidget.this.refreshTree();
            }
        };
        this.fActionFilterPropertyValues.setToolTipText(Messages.SearchWidget_22);
        dropDownAction.add(this.fActionFilterPropertyValues);
        Action actionProperties = new Action(Messages.SearchWidget_5, 1){

            public void run() {
                UserPropertiesKeySelectionDialog dialog = new UserPropertiesKeySelectionDialog(SearchWidget.this.getShell(), SearchWidget.this.getAllUniquePropertyKeys(), new ArrayList<String>(SearchWidget.this.fSearchFilter.getPropertyKeyFilter()));
                if (dialog.open() != 1) {
                    SearchWidget.this.fSearchFilter.resetPropertyKeyFilter();
                    for (String key : dialog.getSelectedKeys()) {
                        SearchWidget.this.fSearchFilter.addPropertyKeyFilter(key);
                    }
                    SearchWidget.this.refreshTree();
                }
            }
        };
        actionProperties.setToolTipText(Messages.SearchWidget_23);
        dropDownAction.add((IAction)actionProperties);
        dropDownAction.add((IContributionItem)new Separator());
        this.fSpecializationsMenu = new MenuManager(Messages.SearchWidget_16);
        dropDownAction.add((IContributionItem)this.fSpecializationsMenu);
        this.populateSpecializationsMenu();
        MenuManager strategyMenu = new MenuManager(Messages.SearchWidget_15);
        dropDownAction.add((IContributionItem)strategyMenu);
        EClass[] eClassArray = ArchimateModelUtils.getStrategyClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            strategyMenu.add(this.createConceptAction(eClass));
            ++n2;
        }
        MenuManager businessMenu = new MenuManager(Messages.SearchWidget_6);
        dropDownAction.add((IContributionItem)businessMenu);
        EClass[] eClassArray2 = ArchimateModelUtils.getBusinessClasses();
        int n3 = eClassArray2.length;
        n = 0;
        while (n < n3) {
            EClass eClass = eClassArray2[n];
            businessMenu.add(this.createConceptAction(eClass));
            ++n;
        }
        MenuManager applicationMenu = new MenuManager(Messages.SearchWidget_7);
        dropDownAction.add((IContributionItem)applicationMenu);
        EClass[] eClassArray3 = ArchimateModelUtils.getApplicationClasses();
        int n4 = eClassArray3.length;
        n3 = 0;
        while (n3 < n4) {
            EClass eClass = eClassArray3[n3];
            applicationMenu.add(this.createConceptAction(eClass));
            ++n3;
        }
        MenuManager technologyPhysicalMenu = new MenuManager(Messages.SearchWidget_8);
        dropDownAction.add((IContributionItem)technologyPhysicalMenu);
        EClass[] eClassArray4 = ArchimateModelUtils.getTechnologyClasses();
        int n5 = eClassArray4.length;
        n4 = 0;
        while (n4 < n5) {
            EClass eClass = eClassArray4[n4];
            technologyPhysicalMenu.add(this.createConceptAction(eClass));
            ++n4;
        }
        technologyPhysicalMenu.add((IContributionItem)new Separator());
        eClassArray4 = ArchimateModelUtils.getPhysicalClasses();
        n5 = eClassArray4.length;
        n4 = 0;
        while (n4 < n5) {
            EClass eClass = eClassArray4[n4];
            technologyPhysicalMenu.add(this.createConceptAction(eClass));
            ++n4;
        }
        MenuManager motivationMenu = new MenuManager(Messages.SearchWidget_9);
        dropDownAction.add((IContributionItem)motivationMenu);
        EClass[] eClassArray5 = ArchimateModelUtils.getMotivationClasses();
        int n6 = eClassArray5.length;
        n5 = 0;
        while (n5 < n6) {
            EClass eClass = eClassArray5[n5];
            motivationMenu.add(this.createConceptAction(eClass));
            ++n5;
        }
        MenuManager implementationMenu = new MenuManager(Messages.SearchWidget_10);
        dropDownAction.add((IContributionItem)implementationMenu);
        EClass[] eClassArray6 = ArchimateModelUtils.getImplementationMigrationClasses();
        int n7 = eClassArray6.length;
        n6 = 0;
        while (n6 < n7) {
            EClass eClass = eClassArray6[n6];
            implementationMenu.add(this.createConceptAction(eClass));
            ++n6;
        }
        MenuManager otherMenu = new MenuManager(Messages.SearchWidget_14);
        dropDownAction.add((IContributionItem)otherMenu);
        EClass[] eClassArray7 = ArchimateModelUtils.getOtherClasses();
        int n8 = eClassArray7.length;
        n7 = 0;
        while (n7 < n8) {
            EClass eClass = eClassArray7[n7];
            otherMenu.add(this.createConceptAction(eClass));
            ++n7;
        }
        otherMenu.add((IContributionItem)new Separator());
        eClassArray7 = ArchimateModelUtils.getConnectorClasses();
        n8 = eClassArray7.length;
        n7 = 0;
        while (n7 < n8) {
            EClass eClass = eClassArray7[n7];
            otherMenu.add(this.createConceptAction(eClass));
            ++n7;
        }
        MenuManager relationsMenu = new MenuManager(Messages.SearchWidget_11);
        dropDownAction.add((IContributionItem)relationsMenu);
        EClass[] eClassArray8 = ArchimateModelUtils.getRelationsClasses();
        int n9 = eClassArray8.length;
        n8 = 0;
        while (n8 < n9) {
            EClass eClass = eClassArray8[n8];
            relationsMenu.add(this.createConceptAction(eClass));
            ++n8;
        }
        this.fActionFilterViews = new Action(Messages.SearchWidget_17, 2){

            public void run() {
                SearchWidget.this.fSearchFilter.setFilterViews(this.isChecked());
                SearchWidget.this.refreshTree();
            }
        };
        this.fActionFilterViews.setToolTipText(Messages.SearchWidget_24);
        dropDownAction.add(this.fActionFilterViews);
        dropDownAction.add((IContributionItem)new Separator());
        this.fActionShowAllFolders = new Action(Messages.SearchWidget_12, 2){

            public void run() {
                SearchWidget.this.fSearchFilter.setShowAllFolders(this.isChecked());
                SearchWidget.this.refreshTree();
            }
        };
        this.fActionShowAllFolders.setToolTipText(Messages.SearchWidget_25);
        dropDownAction.add(this.fActionShowAllFolders);
        this.fActionMatchCase = new Action(Messages.SearchWidget_18, 2){

            public void run() {
                SearchWidget.this.fSearchFilter.setMatchCase(this.isChecked());
                SearchWidget.this.refreshTree();
            }
        };
        this.fActionMatchCase.setToolTipText(Messages.SearchWidget_26);
        dropDownAction.add(this.fActionMatchCase);
        this.fActionUseRegex = new Action(Messages.SearchWidget_19, 2){

            public void run() {
                SearchWidget.this.fSearchFilter.setUseRegex(this.isChecked());
                SearchWidget.this.setValidSearchTextHint();
                SearchWidget.this.refreshTree();
            }
        };
        this.fActionUseRegex.setToolTipText(Messages.SearchWidget_27);
        dropDownAction.add(this.fActionUseRegex);
        dropDownAction.add((IContributionItem)new Separator());
        Action actionReset = new Action(Messages.SearchWidget_13){

            public void run() {
                SearchWidget.this.reset();
            }
        };
        dropDownAction.add((IAction)actionReset);
        this.loadPreferences();
        toolBarmanager.update(true);
    }

    private void loadPreferences() {
        IPreferenceStore store = ArchiPlugin.getInstance().getPreferenceStore();
        this.fActionFilterName.setChecked(store.getBoolean("searchFilterName"));
        this.fSearchFilter.setFilterOnName(this.fActionFilterName.isChecked());
        this.fActionFilterDocumentation.setChecked(store.getBoolean("searchFilterDocumentation"));
        this.fSearchFilter.setFilterOnDocumentation(this.fActionFilterDocumentation.isChecked());
        this.fActionFilterPropertyValues.setChecked(store.getBoolean("searchFilterPropertyValues"));
        this.fSearchFilter.setFilterOnPropertyValues(this.fActionFilterPropertyValues.isChecked());
        this.fActionFilterViews.setChecked(store.getBoolean("searchFilterViews"));
        this.fSearchFilter.setFilterViews(this.fActionFilterViews.isChecked());
        this.fActionShowAllFolders.setChecked(store.getBoolean("searchFilterShowAllFolders"));
        this.fSearchFilter.setShowAllFolders(this.fActionShowAllFolders.isChecked());
        this.fActionMatchCase.setChecked(store.getBoolean("searchFilterMatchCase"));
        this.fSearchFilter.setMatchCase(this.fActionMatchCase.isChecked());
        this.fActionUseRegex.setChecked(store.getBoolean("searchFilterUseRegex"));
        this.fSearchFilter.setUseRegex(this.fActionUseRegex.isChecked());
    }

    private void savePreferences() {
        IPreferenceStore store = ArchiPlugin.getInstance().getPreferenceStore();
        store.setValue("searchFilterName", this.fSearchFilter.getFilterOnName());
        store.setValue("searchFilterDocumentation", this.fSearchFilter.getFilterOnDocumentation());
        store.setValue("searchFilterPropertyValues", this.fSearchFilter.getFilterOnPropertyValues());
        store.setValue("searchFilterViews", this.fSearchFilter.isFilteringViews());
        store.setValue("searchFilterShowAllFolders", this.fSearchFilter.getShowAllFolders());
        store.setValue("searchFilterMatchCase", this.fSearchFilter.getMatchCase());
        store.setValue("searchFilterUseRegex", this.fSearchFilter.getUseRegex());
    }

    private void reset() {
        this.fActionFilterName.setChecked(true);
        this.fActionFilterDocumentation.setChecked(false);
        this.fActionFilterPropertyValues.setChecked(false);
        this.populateSpecializationsMenu();
        for (IAction action : this.fConceptActions) {
            action.setChecked(false);
        }
        this.fActionFilterViews.setChecked(false);
        this.fSearchFilter.reset();
        this.refreshTree();
    }

    public void softReset() {
        this.fSearchFilter.resetPropertyKeyFilter();
        this.populateSpecializationsMenu();
        this.fSearchFilter.resetSpecializationsFilter();
        this.refreshTree();
    }

    private IAction createConceptAction(final EClass eClass) {
        Action action = new Action(ArchiLabelProvider.INSTANCE.getDefaultName(eClass), 2){

            public void run() {
                if (this.isChecked()) {
                    SearchWidget.this.fSearchFilter.addConceptFilter(eClass);
                } else {
                    SearchWidget.this.fSearchFilter.removeConceptFilter(eClass);
                }
                SearchWidget.this.refreshTree();
            }

            public ImageDescriptor getImageDescriptor() {
                return PlatformUtils.isWindows11() ? null : ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass);
            }
        };
        this.fConceptActions.add((IAction)action);
        return action;
    }

    private List<String> getAllUniquePropertyKeys() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        block0: for (IArchimateModel model : IEditorModelManager.INSTANCE.getModels()) {
            TreeIterator iter = model.eAllContents();
            while (iter.hasNext()) {
                IProperty property;
                String key;
                EObject element = (EObject)iter.next();
                if (!(element instanceof IProperty) || !StringUtils.isSetAfterTrim(key = (property = (IProperty)element).getKey())) continue;
                set.add(key);
                if (set.size() > 1000000) continue block0;
            }
        }
        ArrayList<String> list = new ArrayList<String>(set);
        list.sort((s1, s2) -> s1.compareToIgnoreCase((String)s2));
        return list;
    }

    private void populateSpecializationsMenu() {
        this.fSpecializationsMenu.removeAll();
        ArrayList<IProfile> profiles = new ArrayList<IProfile>();
        for (IArchimateModel model : IEditorModelManager.INSTANCE.getModels()) {
            for (Map.Entry entry : ArchimateModelUtils.findProfilesUsage((IArchimateModel)model).entrySet()) {
                if (this.hasProfile(profiles, (IProfile)entry.getKey())) continue;
                profiles.add((IProfile)entry.getKey());
            }
        }
        Collator collator = Collator.getInstance();
        profiles.sort((p1, p2) -> collator.compare(p1.getName(), p2.getName()));
        for (final IProfile profile : profiles) {
            Action action = new Action(profile.getName(), 2){

                public void run() {
                    if (this.isChecked()) {
                        SearchWidget.this.fSearchFilter.addSpecializationsFilter(profile);
                    } else {
                        SearchWidget.this.fSearchFilter.removeSpecializationsFilter(profile);
                    }
                    SearchWidget.this.refreshTree();
                }

                public ImageDescriptor getImageDescriptor() {
                    return PlatformUtils.isWindows11() ? null : ArchiLabelProvider.INSTANCE.getImageDescriptor(profile.getConceptClass());
                }
            };
            this.fSpecializationsMenu.add((IAction)action);
        }
        this.fSpecializationsMenu.update(true);
    }

    private boolean hasProfile(List<IProfile> profiles, IProfile profile) {
        for (IProfile p : profiles) {
            if (!ArchimateModelUtils.isMatchingProfile((IProfile)p, (IProfile)profile)) continue;
            return true;
        }
        return false;
    }

    private void refreshTree() {
        Display.getCurrent().asyncExec(() -> {
            if (this.fViewer == null || this.fViewer.getTree().isDisposed()) {
                return;
            }
            this.fViewer.collapseAll();
            this.fViewer.refresh();
            if (this.fSearchFilter.isFiltering()) {
                this.fViewer.expandAll();
            } else {
                this.restoreTreeState();
            }
        });
    }

    private void saveTreeState() {
        this.fExpandedTreeObjects = new HashSet<Object>(Arrays.asList(this.fViewer.getVisibleExpandedElements()));
    }

    private void restoreTreeState() {
        if (this.fExpandedTreeObjects != null) {
            try {
                this.fViewer.getTree().setRedraw(false);
                this.fViewer.setExpandedElements(this.fExpandedTreeObjects.toArray());
            }
            finally {
                this.fViewer.getTree().setRedraw(true);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.savePreferences();
        this.fViewer.removeTreeListener(this.treeExpansionListener);
        if (this.fSearchFilter.isFiltering()) {
            ITreeSelection selection = this.fViewer.getStructuredSelection();
            this.fViewer.collapseAll();
            this.fViewer.removeFilter((ViewerFilter)this.fSearchFilter);
            this.restoreTreeState();
            this.fViewer.setSelection((ISelection)selection, true);
        } else {
            this.fViewer.removeFilter((ViewerFilter)this.fSearchFilter);
        }
        this.fExpandedTreeObjects = null;
        this.fViewer = null;
        this.fSearchFilter = null;
        this.fConceptActions = null;
        this.fSpecializationsMenu = null;
    }
}

