/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports;

import com.archimatetool.jasperreports.ExportJasperReportsWizardPage1;
import com.archimatetool.jasperreports.ExportJasperReportsWizardPage2;
import com.archimatetool.jasperreports.JasperReportsExporter;
import com.archimatetool.jasperreports.Messages;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ExportJasperReportsWizard
extends Wizard {
    private IArchimateModel fModel;
    private ExportJasperReportsWizardPage1 fPage1;
    private ExportJasperReportsWizardPage2 fPage2;
    private File mainTemplateFile;
    private Locale locale;
    private File exportFolder;
    private String exportFileName;
    private String reportTitle;
    private int exportOptions;

    public ExportJasperReportsWizard(IArchimateModel model) {
        this.setWindowTitle(Messages.ExportJasperReportsWizard_0);
        this.fModel = model;
    }

    public void addPages() {
        this.fPage1 = new ExportJasperReportsWizardPage1(this.fModel);
        this.addPage((IWizardPage)this.fPage1);
        this.fPage2 = new ExportJasperReportsWizardPage2();
        this.addPage((IWizardPage)this.fPage2);
    }

    public boolean performFinish() {
        this.fPage1.storePreferences();
        this.mainTemplateFile = this.fPage2.getMainTemplateFile();
        if (this.mainTemplateFile == null || !this.mainTemplateFile.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportJasperReportsWizard_1, (String)Messages.ExportJasperReportsWizard_2);
            return false;
        }
        this.locale = this.fPage2.getLocale();
        this.exportFolder = this.fPage1.getExportFolder();
        this.exportFileName = this.fPage1.getExportFilename();
        this.reportTitle = this.fPage1.getReportTitle();
        this.exportOptions = this.fPage1.getExportOptions();
        try {
            File exportFile = new File(this.exportFolder, this.exportFileName);
            exportFile.getCanonicalPath();
            this.exportFolder.mkdirs();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportJasperReportsWizard_3, (String)Messages.ExportJasperReportsWizard_4);
            return false;
        }
        return true;
    }

    public void runWithProgress() {
        Throwable[] exception = new Throwable[1];
        IRunnableWithProgress runnable = monitor -> {
            block2: {
                try {
                    JasperReportsExporter exporter = new JasperReportsExporter(this.fModel, this.exportFolder, this.exportFileName, this.mainTemplateFile, this.reportTitle, this.locale, this.exportOptions);
                    exporter.export(monitor);
                }
                catch (Throwable ex) {
                    if (ex instanceof JasperReportsExporter.CancelledException) break block2;
                    ex.printStackTrace();
                    throwableArray[0] = ex;
                }
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(false, true, runnable);
        }
        catch (InterruptedException | InvocationTargetException ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportJasperReportsWizard_5, (String)ex.getMessage());
        }
        if (exception[0] != null) {
            exception[0].printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportJasperReportsWizard_5, (String)exception[0].getMessage());
        }
    }
}

