/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.jasperreports.JasperReportsPlugin;
import com.archimatetool.jasperreports.Messages;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportJasperReportsWizardPage1
extends WizardPage {
    private static String HELP_ID = "com.archimatetool.help.ExportJasperReportsWizardPage1";
    static final String PREFS_LAST_FOLDER = "JR_LastFolder";
    static final String PREFS_LAST_FILENAME = "JR_Filename";
    static final String PREFS_EXPORT_OPTIONS = "JR_ExportOptions";
    private IArchimateModel fModel;
    private Text fTextOutputFolder;
    private Text fTextFilename;
    private Text fTextReportTitle;
    private Button fButtonExportHTML;
    private Button fButtonExportPDF;
    private Button fButtonExportDOCX;
    private Button fButtonExportPPTX;
    private Button fButtonExportODT;
    private Button fButtonExportRTF;
    private Image fImageHTML;
    private Image fImagePDF;
    private Image fImageDOCX;
    private Image fImagePPTX;
    private Image fImageODT;
    private Image fImageRTF;

    public ExportJasperReportsWizardPage1(IArchimateModel model) {
        super("ExportJasperReportsWizardPage1");
        this.setTitle(Messages.ExportJasperReportsWizardPage1_0);
        this.setDescription(Messages.ExportJasperReportsWizardPage1_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/exportdir_wiz.png"));
        this.fModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        IPreferenceStore store = JasperReportsPlugin.getInstance().getPreferenceStore();
        Composite fieldContainer = new Composite(container, 0);
        fieldContainer.setLayoutData((Object)new GridData(768));
        fieldContainer.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(fieldContainer, 0);
        label.setText(Messages.ExportJasperReportsWizardPage1_2);
        this.fTextOutputFolder = UIUtils.createSingleTextControl((Composite)fieldContainer, (int)2048, (boolean)false);
        this.fTextOutputFolder.setLayoutData((Object)new GridData(768));
        String lastFolder = store.getString(PREFS_LAST_FOLDER);
        if (StringUtils.isSet((String)lastFolder)) {
            this.fTextOutputFolder.setText(lastFolder);
        } else {
            this.fTextOutputFolder.setText(new File(System.getProperty("user.home"), "exported").getPath());
        }
        this.fTextOutputFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        Button button = new Button(fieldContainer, 8);
        button.setText(Messages.ExportJasperReportsWizardPage1_3);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportJasperReportsWizardPage1.this.handleBrowse();
            }
        });
        label = new Label(fieldContainer, 0);
        label.setText(Messages.ExportJasperReportsWizardPage1_4);
        this.fTextFilename = UIUtils.createSingleTextControl((Composite)fieldContainer, (int)2048, (boolean)false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fTextFilename.setLayoutData((Object)gd);
        String lastFilename = store.getString(PREFS_LAST_FILENAME);
        if (StringUtils.isSet((String)lastFilename)) {
            this.fTextFilename.setText(lastFilename);
        } else {
            this.fTextFilename.setText("report-filename");
        }
        this.fTextFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        label = new Label(fieldContainer, 0);
        label.setText(Messages.ExportJasperReportsWizardPage1_5);
        this.fTextReportTitle = UIUtils.createSingleTextControl((Composite)fieldContainer, (int)2048, (boolean)false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fTextReportTitle.setLayoutData((Object)gd);
        this.fTextReportTitle.setText(this.fModel.getName());
        this.fTextReportTitle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        this.loadImages();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExportJasperReportsWizardPage1.this.disposeImages();
            }
        });
        Group exportTypesGroup = new Group(container, 0);
        exportTypesGroup.setText(Messages.ExportJasperReportsWizardPage1_6);
        exportTypesGroup.setLayout((Layout)new GridLayout(4, false));
        exportTypesGroup.setLayoutData((Object)new GridData(768));
        int exportOptions = store.getInt(PREFS_EXPORT_OPTIONS);
        if (exportOptions == 0) {
            exportOptions = 1;
        }
        label = new Label((Composite)exportTypesGroup, 0);
        label.setImage(this.fImageHTML);
        this.fButtonExportHTML = new Button((Composite)exportTypesGroup, 32);
        this.fButtonExportHTML.setText(Messages.ExportJasperReportsWizardPage1_7);
        this.fButtonExportHTML.setLayoutData((Object)new GridData(768));
        this.fButtonExportHTML.setSelection((exportOptions & 1) != 0);
        this.fButtonExportHTML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        label = new Label((Composite)exportTypesGroup, 0);
        label.setImage(this.fImagePDF);
        this.fButtonExportPDF = new Button((Composite)exportTypesGroup, 32);
        this.fButtonExportPDF.setText(Messages.ExportJasperReportsWizardPage1_8);
        this.fButtonExportPDF.setLayoutData((Object)new GridData(768));
        this.fButtonExportPDF.setSelection((exportOptions & 2) != 0);
        this.fButtonExportPDF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        label = new Label((Composite)exportTypesGroup, 0);
        label.setImage(this.fImageRTF);
        this.fButtonExportRTF = new Button((Composite)exportTypesGroup, 32);
        this.fButtonExportRTF.setText(Messages.ExportJasperReportsWizardPage1_9);
        this.fButtonExportRTF.setLayoutData((Object)new GridData(768));
        this.fButtonExportRTF.setSelection((exportOptions & 0x10) != 0);
        this.fButtonExportRTF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        label = new Label((Composite)exportTypesGroup, 0);
        label.setImage(this.fImageDOCX);
        this.fButtonExportDOCX = new Button((Composite)exportTypesGroup, 32);
        this.fButtonExportDOCX.setText(Messages.ExportJasperReportsWizardPage1_10);
        this.fButtonExportDOCX.setLayoutData((Object)new GridData(768));
        this.fButtonExportDOCX.setSelection((exportOptions & 4) != 0);
        this.fButtonExportDOCX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        label = new Label((Composite)exportTypesGroup, 0);
        label.setImage(this.fImagePPTX);
        this.fButtonExportPPTX = new Button((Composite)exportTypesGroup, 32);
        this.fButtonExportPPTX.setText(Messages.ExportJasperReportsWizardPage1_11);
        this.fButtonExportPPTX.setLayoutData((Object)new GridData(768));
        this.fButtonExportPPTX.setSelection((exportOptions & 8) != 0);
        this.fButtonExportPPTX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
        label = new Label((Composite)exportTypesGroup, 0);
        label.setImage(this.fImageODT);
        this.fButtonExportODT = new Button((Composite)exportTypesGroup, 32);
        this.fButtonExportODT.setText(Messages.ExportJasperReportsWizardPage1_12);
        this.fButtonExportODT.setLayoutData((Object)new GridData(768));
        this.fButtonExportODT.setSelection((exportOptions & 0x20) != 0);
        this.fButtonExportODT.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportJasperReportsWizardPage1.this.validateFields();
            }
        });
    }

    public File getExportFolder() {
        return new File(this.fTextOutputFolder.getText());
    }

    public String getExportFilename() {
        return this.fTextFilename.getText();
    }

    public String getReportTitle() {
        return this.fTextReportTitle.getText();
    }

    public int getExportOptions() {
        int options = 0;
        options |= this.isExportPDF() ? 2 : 0;
        options |= this.isExportHTML() ? 1 : 0;
        options |= this.isExportDOCX() ? 4 : 0;
        options |= this.isExportPPT() ? 8 : 0;
        options |= this.isExportODT() ? 32 : 0;
        return options |= this.isExportRTF() ? 16 : 0;
    }

    public boolean isExportHTML() {
        return this.fButtonExportHTML.getSelection();
    }

    public boolean isExportPDF() {
        return this.fButtonExportPDF.getSelection();
    }

    public boolean isExportDOCX() {
        return this.fButtonExportDOCX.getSelection();
    }

    public boolean isExportPPT() {
        return this.fButtonExportPPTX.getSelection();
    }

    public boolean isExportODT() {
        return this.fButtonExportODT.getSelection();
    }

    public boolean isExportRTF() {
        return this.fButtonExportRTF.getSelection();
    }

    private void validateFields() {
        boolean isOK;
        boolean bl = isOK = this.isExportHTML() || this.isExportPDF() || this.isExportDOCX() || this.isExportPPT() || this.isExportODT() || this.isExportRTF();
        if (!isOK) {
            this.updateStatus(Messages.ExportJasperReportsWizardPage1_13);
            return;
        }
        String s = this.fTextOutputFolder.getText();
        if ("".equals(s.trim())) {
            this.updateStatus(Messages.ExportJasperReportsWizardPage1_14);
            return;
        }
        s = this.fTextFilename.getText();
        if ("".equals(s.trim())) {
            this.updateStatus(Messages.ExportJasperReportsWizardPage1_15);
            return;
        }
        s = this.fTextReportTitle.getText();
        if ("".equals(s.trim())) {
            this.updateStatus(Messages.ExportJasperReportsWizardPage1_16);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private void handleBrowse() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.ExportJasperReportsWizardPage1_17);
        dialog.setMessage(Messages.ExportJasperReportsWizardPage1_18);
        dialog.setFilterPath(this.fTextOutputFolder.getText());
        String path = dialog.open();
        if (path != null) {
            this.fTextOutputFolder.setText(path);
        }
    }

    private void loadImages() {
        this.fImageDOCX = this.loadImage("img/docx.png");
        this.fImageHTML = this.loadImage("img/html.png");
        this.fImageODT = this.loadImage("img/odt.png");
        this.fImagePDF = this.loadImage("img/pdf.gif");
        this.fImagePPTX = this.loadImage("img/pptx.png");
        this.fImageRTF = this.loadImage("img/rtf.png");
    }

    private void disposeImages() {
        if (this.fImageDOCX != null) {
            this.fImageDOCX.dispose();
        }
        if (this.fImageHTML != null) {
            this.fImageHTML.dispose();
        }
        if (this.fImageODT != null) {
            this.fImageODT.dispose();
        }
        if (this.fImagePDF != null) {
            this.fImagePDF.dispose();
        }
        if (this.fImagePPTX != null) {
            this.fImagePPTX.dispose();
        }
        if (this.fImageRTF != null) {
            this.fImageRTF.dispose();
        }
    }

    private Image loadImage(String name) {
        Image image = null;
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        if (is != null) {
            image = new Image(null, is);
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return image;
    }

    void storePreferences() {
        IPreferenceStore store = JasperReportsPlugin.getInstance().getPreferenceStore();
        store.setValue(PREFS_LAST_FOLDER, this.getExportFolder().getAbsolutePath());
        store.setValue(PREFS_LAST_FILENAME, this.getExportFilename());
        store.setValue(PREFS_EXPORT_OPTIONS, this.getExportOptions());
    }
}

