/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports;

import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.ui.ImageFactory;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.jasperreports.JasperReportsPlugin;
import com.archimatetool.jasperreports.Messages;
import com.archimatetool.jasperreports.data.ArchimateModelDataSource;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class JasperReportsExporter {
    public static final int EXPORT_HTML = 1;
    public static final int EXPORT_PDF = 2;
    public static final int EXPORT_DOCX = 4;
    public static final int EXPORT_PPT = 8;
    public static final int EXPORT_RTF = 16;
    public static final int EXPORT_ODT = 32;
    private boolean DELETE_TEMP_FILES = true;
    private IArchimateModel fModel;
    private File fExportFolder;
    private String fExportFileName;
    private File fMainTemplateFile;
    private String fReportTitle;
    private int fExportOptions;
    private Locale fLocale;
    private IProgressMonitor progressMonitor;

    public JasperReportsExporter(IArchimateModel model, File exportFolder, String exportFileName, File mainTemplateFile, String reportTitle, Locale locale, int exportOptions) {
        this.fModel = model;
        this.fExportFolder = exportFolder;
        this.fExportFileName = exportFileName;
        this.fMainTemplateFile = mainTemplateFile;
        this.fReportTitle = reportTitle;
        this.fExportOptions = exportOptions;
        this.fLocale = locale == null ? Locale.getDefault() : locale;
    }

    public void export(IProgressMonitor monitor) throws IOException, JRException {
        this.progressMonitor = monitor;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(Messages.JasperReportsExporter_0, -1);
        }
        File tmpFolder = new File(this.fExportFolder, "tmp");
        tmpFolder.mkdirs();
        try {
            this.writeDiagrams(tmpFolder);
            JasperPrint jasperPrint = this.createJasperPrint(tmpFolder);
            if ((this.fExportOptions & 1) != 0) {
                this.setProgressSubTask(Messages.JasperReportsExporter_3);
                this.exportHTML(jasperPrint, new File(this.fExportFolder, this.fExportFileName + ".html"));
            }
            if ((this.fExportOptions & 2) != 0) {
                this.setProgressSubTask(Messages.JasperReportsExporter_4);
                this.exportPDF(jasperPrint, new File(this.fExportFolder, this.fExportFileName + ".pdf"));
            }
            if ((this.fExportOptions & 4) != 0) {
                this.setProgressSubTask(Messages.JasperReportsExporter_5);
                this.exportDOCX(jasperPrint, new File(this.fExportFolder, this.fExportFileName + ".docx"));
            }
            if ((this.fExportOptions & 8) != 0) {
                this.setProgressSubTask(Messages.JasperReportsExporter_6);
                this.exportPPT(jasperPrint, new File(this.fExportFolder, this.fExportFileName + ".pptx"));
            }
            if ((this.fExportOptions & 0x10) != 0) {
                this.setProgressSubTask(Messages.JasperReportsExporter_7);
                this.exportRTF(jasperPrint, new File(this.fExportFolder, this.fExportFileName + ".rtf"));
            }
            if ((this.fExportOptions & 0x20) != 0) {
                this.setProgressSubTask(Messages.JasperReportsExporter_8);
                this.exportODT(jasperPrint, new File(this.fExportFolder, this.fExportFileName + ".odt"));
            }
        }
        finally {
            if (this.DELETE_TEMP_FILES) {
                this.setProgressSubTask(Messages.JasperReportsExporter_9);
                FileUtils.deleteFolder((File)tmpFolder);
            }
        }
    }

    void writeDiagrams(File tmpFolder) throws IOException {
        EList diagramModels = this.fModel.getDiagramModels();
        int total = diagramModels.size();
        int i = 1;
        for (IDiagramModel dm : diagramModels) {
            this.setProgressSubTask(NLS.bind((String)Messages.JasperReportsExporter_1, (Object)i++, (Object)total));
            Image image = null;
            try {
                try {
                    image = DiagramUtils.createImage((IDiagramModel)dm, (double)1.0, (int)10);
                    String diagramName = dm.getId() + ".png";
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{image.getImageData(ImageFactory.getImageDeviceZoom())};
                    File file = new File(tmpFolder, diagramName);
                    loader.save(file.getAbsolutePath(), 5);
                }
                catch (Throwable t) {
                    throw new IOException("Error saving image for: " + dm.getName() + "\n" + (t.getMessage() == null ? t.toString() : t.getMessage()), t);
                }
            }
            finally {
                if (image != null) {
                    image.dispose();
                }
            }
        }
    }

    JasperPrint createJasperPrint(File tmpFolder) throws JRException, IOException {
        this.setProgressSubTask(Messages.JasperReportsExporter_2);
        File propsFile = new File(JasperReportsPlugin.getInstance().getPluginFolder(), "jasperreports.properties");
        System.setProperty("net.sf.jasperreports.properties", propsFile.getAbsolutePath());
        System.setProperty("JASPER_IMAGE_PATH", tmpFolder.getPath());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("REPORT_TITLE", this.fReportTitle);
        File reportFolder = this.fMainTemplateFile.getParentFile();
        File bundleFile = new File(reportFolder, "strings.properties");
        if (bundleFile.canRead()) {
            URLClassLoader loader = new URLClassLoader(new URL[]{reportFolder.toURI().toURL()});
            ResourceBundle resourceBundle = ResourceBundle.getBundle("strings", this.fLocale, loader);
            params.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        }
        params.put("REPORT_LOCALE", this.fLocale);
        params.put("REPORT_PATH", reportFolder.toString() + File.separator);
        if (this.fModel.getFile() != null) {
            params.put("MODEL_FILE", this.fModel.getFile().getAbsolutePath());
            params.put("MODEL_DIRECTORY", this.fModel.getFile().getParent() + File.separator);
        }
        this.setProgressSubTask(Messages.JasperReportsExporter_10);
        JasperReport mainReport = JasperCompileManager.compileReport((String)this.fMainTemplateFile.getPath());
        File[] fileArray = reportFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.equals(this.fMainTemplateFile) && file.getName().endsWith(".jrxml")) {
                JasperReport jr = JasperCompileManager.compileReport((String)file.getPath());
                params.put(jr.getName(), jr);
            }
            ++n2;
        }
        this.setProgressSubTask(Messages.JasperReportsExporter_11);
        return JasperFillManager.fillReport((JasperReport)mainReport, params, (JRDataSource)new ArchimateModelDataSource(this.fModel));
    }

    void exportHTML(JasperPrint jasperPrint, File file) throws JRException {
        JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)file.getPath());
    }

    void exportPDF(JasperPrint jasperPrint, File file) throws JRException {
        JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)file.getPath());
    }

    void exportDOCX(JasperPrint jasperPrint, File file) throws JRException {
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
        exporter.exportReport();
    }

    void exportPPT(JasperPrint jasperPrint, File file) throws JRException {
        JRPptxExporter exporter = new JRPptxExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
        exporter.exportReport();
    }

    void exportODT(JasperPrint jasperPrint, File file) throws JRException {
        JROdtExporter exporter = new JROdtExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(file));
        exporter.exportReport();
    }

    void exportRTF(JasperPrint jasperPrint, File file) throws JRException {
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(file));
        exporter.exportReport();
    }

    private void setProgressSubTask(String task) throws CancelledException {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(task);
            if (this.progressMonitor.isCanceled()) {
                throw new CancelledException();
            }
            if (PlatformUI.isWorkbenchRunning() && Display.getCurrent() != null) {
                while (Display.getCurrent().readAndDispatch()) {
                }
            }
        }
    }

    static class CancelledException
    extends IOException {
        CancelledException() {
        }
    }
}

