/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JasperReportsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.archimatetool.jasperreports";
    private static JasperReportsPlugin instance;

    public static JasperReportsPlugin getInstance() {
        return instance;
    }

    public JasperReportsPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getUserTemplatesFolder().mkdirs();
    }

    public File getUserTemplatesFolder() {
        File f;
        String s = this.getPreferenceStore().getString("JRUserReportsFolder");
        if (StringUtils.isSetAfterTrim((String)s) && (f = new File(s)).exists() && f.isDirectory()) {
            return f;
        }
        return this.getDefaultUserTemplatesFolder();
    }

    public File getDefaultUserTemplatesFolder() {
        return new File(ArchiPlugin.getInstance().getUserDataFolder(), "jasper-reports");
    }

    public File getJasperReportsFolder() {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("$nl$/reports"), null);
        try {
            url = FileLocator.resolve((URL)url);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return new File(url.getPath());
    }

    public File getPluginFolder() {
        try {
            URL url = FileLocator.resolve((URL)this.getBundle().getEntry("/"));
            return new File(url.getPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

