/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports.data;

import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.jasperreports.data.ElementsDataSource;
import com.archimatetool.jasperreports.data.FieldDataFactory;
import com.archimatetool.jasperreports.data.IPropertiesDataSource;
import com.archimatetool.jasperreports.data.PropertiesModelDataSource;
import com.archimatetool.jasperreports.data.ViewModelDataSource;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.INameable;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ArchimateModelDataSource
implements JRDataSource,
IPropertiesDataSource {
    private IArchimateModel fModel;
    private boolean done;

    public ArchimateModelDataSource(IArchimateModel model) {
        this.fModel = model;
    }

    public IArchimateModel getModel() {
        return this.fModel;
    }

    @Override
    public PropertiesModelDataSource getPropertiesDataSource() {
        return new PropertiesModelDataSource((IProperties)this.fModel);
    }

    public ViewModelDataSource getViewsDataSource() {
        return new ViewModelDataSource(this.fModel);
    }

    public ElementsDataSource getElementsDataSource(String types) {
        return new ElementsDataSource(this.fModel, types);
    }

    public boolean hasElements(String types) {
        return !new ElementsDataSource((IArchimateModel)this.fModel, (String)types).fConcepts.isEmpty();
    }

    @Override
    public Object getElement() {
        return this.fModel;
    }

    public Object getElementByID(String id) {
        return ArchimateModelUtils.getObjectByID((IArchimateModel)this.fModel, (String)id);
    }

    public boolean next() throws JRException {
        if (!this.done) {
            this.done = true;
            return true;
        }
        return false;
    }

    public ArchimateModelDataSource clone() {
        return new ArchimateModelDataSource(this.fModel);
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        return FieldDataFactory.getFieldValue(this.fModel, jrField.getName());
    }

    public static Set<EClass> getClasses(String types) {
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        String[] stringArray = types.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            switch (type.trim().toLowerCase()) {
                case "elements": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getAllArchimateClasses()));
                    break;
                }
                case "strategy": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getStrategyClasses()));
                    break;
                }
                case "business": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getBusinessClasses()));
                    break;
                }
                case "application": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getApplicationClasses()));
                    break;
                }
                case "technology": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getTechnologyClasses()));
                    break;
                }
                case "physical": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getPhysicalClasses()));
                    break;
                }
                case "motivation": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getMotivationClasses()));
                    break;
                }
                case "impl_migration": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getImplementationMigrationClasses()));
                    break;
                }
                case "other": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getOtherClasses()));
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getConnectorClasses()));
                    break;
                }
                case "relations": {
                    eClasses.addAll(Arrays.asList(ArchimateModelUtils.getRelationsClasses()));
                    break;
                }
                default: {
                    EClass eClass = (EClass)IArchimatePackage.eINSTANCE.getEClassifier(type.trim());
                    if (eClass == null) break;
                    eClasses.add(eClass);
                }
            }
            ++n2;
        }
        return eClasses;
    }

    public static Set<IArchimateConcept> getConceptsInDiagram(IDiagramModel dm, String types) {
        LinkedHashSet<IArchimateConcept> concepts = new LinkedHashSet<IArchimateConcept>();
        Set<EClass> desiredEClasses = ArchimateModelDataSource.getClasses(types);
        TreeIterator iter = dm.eAllContents();
        while (iter.hasNext()) {
            IArchimateConcept concept;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IDiagramModelArchimateComponent) || (concept = ((IDiagramModelArchimateComponent)eObject).getArchimateConcept()) == null || !desiredEClasses.contains(concept.eClass())) continue;
            concepts.add(concept);
        }
        return concepts;
    }

    public static void sort(List<? extends INameable> list) {
        Collections.sort(list, new Comparator<INameable>(){

            @Override
            public int compare(INameable name1, INameable name2) {
                return ArchimateModelDataSource.compareName(name1, name2);
            }
        });
    }

    public static void sortByTypeThenName(List<? extends INameable> list) {
        Collections.sort(list, new Comparator<INameable>(){

            @Override
            public int compare(INameable o1, INameable o2) {
                int returnValue = ArchimateModelDataSource.compareType((EObject)o1, (EObject)o2);
                return returnValue == 0 ? ArchimateModelDataSource.compareName(o1, o2) : returnValue;
            }
        });
    }

    private static int compareName(INameable o1, INameable o2) {
        String name1 = StringUtils.safeString((String)o1.getName()).toLowerCase().trim();
        String name2 = StringUtils.safeString((String)o2.getName()).toLowerCase().trim();
        return name1.compareTo(name2);
    }

    private static int compareType(EObject o1, EObject o2) {
        String class1 = o1.eClass().getName();
        String class2 = o2.eClass().getName();
        return class1.compareTo(class2);
    }
}

