/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports.data;

import com.archimatetool.jasperreports.data.IDataSource;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.eclipse.emf.common.util.EList;

public class PropertiesModelDataSource
implements JRRewindableDataSource,
IDataSource {
    private EList<IProperty> fProperties;
    private IProperty fCurrentProperty;
    private int currentIndex = -1;

    public PropertiesModelDataSource(IProperties properties) {
        this.fProperties = properties.getProperties();
    }

    public boolean next() throws JRException {
        this.fCurrentProperty = this.currentIndex < this.fProperties.size() - 1 ? (IProperty)this.fProperties.get(++this.currentIndex) : null;
        return this.fCurrentProperty != null;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        if ("key".equals(fieldName)) {
            return this.fCurrentProperty.getKey();
        }
        if ("value".equals(fieldName)) {
            return this.fCurrentProperty.getValue();
        }
        return null;
    }

    public void moveFirst() throws JRException {
        this.currentIndex = -1;
    }

    public IProperty getElement() {
        return this.fCurrentProperty;
    }

    public int size() {
        return this.fProperties.size();
    }
}

