/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports.data;

import com.archimatetool.jasperreports.data.ArchimateModelDataSource;
import com.archimatetool.jasperreports.data.FieldDataFactory;
import com.archimatetool.jasperreports.data.IPropertiesDataSource;
import com.archimatetool.jasperreports.data.PropertiesModelDataSource;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IProperties;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class ViewChildrenDataSource
implements JRRewindableDataSource,
IPropertiesDataSource {
    private List<IArchimateConcept> fChildren = new ArrayList<IArchimateConcept>();
    private IArchimateConcept fCurrentElement;
    private int currentIndex = -1;

    public ViewChildrenDataSource(IDiagramModel dm) {
        this(dm, false);
    }

    public ViewChildrenDataSource(IDiagramModel dm, boolean sortFirstByType) {
        this.fChildren.addAll(ArchimateModelDataSource.getConceptsInDiagram(dm, "elements"));
        if (sortFirstByType) {
            ArchimateModelDataSource.sortByTypeThenName(this.fChildren);
        } else {
            ArchimateModelDataSource.sort(this.fChildren);
        }
    }

    public ViewChildrenDataSource(IDiagramModel dm, String types) {
        this(dm, types, false);
    }

    public ViewChildrenDataSource(IDiagramModel dm, String types, boolean sortFirstByType) {
        this.fChildren.addAll(ArchimateModelDataSource.getConceptsInDiagram(dm, types));
        if (sortFirstByType) {
            ArchimateModelDataSource.sortByTypeThenName(this.fChildren);
        } else {
            ArchimateModelDataSource.sort(this.fChildren);
        }
    }

    public boolean next() throws JRException {
        this.fCurrentElement = this.currentIndex < this.fChildren.size() - 1 ? this.fChildren.get(++this.currentIndex) : null;
        return this.fCurrentElement != null;
    }

    @Override
    public PropertiesModelDataSource getPropertiesDataSource() {
        return new PropertiesModelDataSource((IProperties)this.fCurrentElement);
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        return FieldDataFactory.getFieldValue(this.fCurrentElement, jrField.getName());
    }

    public void moveFirst() throws JRException {
        this.currentIndex = -1;
    }

    public IArchimateConcept getElement() {
        return this.fCurrentElement;
    }

    public int size() {
        return this.fChildren.size();
    }
}

