/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports.data;

import com.archimatetool.jasperreports.data.ArchimateModelDataSource;
import com.archimatetool.jasperreports.data.FieldDataFactory;
import com.archimatetool.jasperreports.data.IPropertiesDataSource;
import com.archimatetool.jasperreports.data.Messages;
import com.archimatetool.jasperreports.data.PropertiesModelDataSource;
import com.archimatetool.jasperreports.data.ViewChildrenDataSource;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.eclipse.osgi.util.NLS;

public class ViewModelDataSource
implements JRRewindableDataSource,
IPropertiesDataSource {
    private List<IDiagramModel> fViews;
    private IDiagramModel fCurrentView;
    private int currentIndex = -1;

    public ViewModelDataSource(IArchimateModel model) {
        this((List<IDiagramModel>)model.getDiagramModels());
    }

    public ViewModelDataSource(List<IDiagramModel> diagramModels) {
        this.fViews = new ArrayList<IDiagramModel>(diagramModels);
        ArchimateModelDataSource.sort(this.fViews);
    }

    public String getViewpointName() {
        if (this.fCurrentView instanceof IArchimateDiagramModel) {
            String id = ((IArchimateDiagramModel)this.fCurrentView).getViewpoint();
            IViewpoint vp = ViewpointManager.INSTANCE.getViewpoint(id);
            if (vp == ViewpointManager.NONE_VIEWPOINT) {
                return Messages.ViewModelDataSource_1;
            }
            String name = vp.getName();
            return name == null ? "" : NLS.bind((String)Messages.ViewModelDataSource_0, (Object)name);
        }
        return null;
    }

    @Override
    public PropertiesModelDataSource getPropertiesDataSource() {
        return new PropertiesModelDataSource((IProperties)this.fCurrentView);
    }

    public ViewChildrenDataSource getChildElementsDataSource() {
        return new ViewChildrenDataSource(this.fCurrentView);
    }

    public ViewChildrenDataSource getChildElementsDataSourceForTypes(String types) {
        return new ViewChildrenDataSource(this.fCurrentView, types);
    }

    public ViewChildrenDataSource getChildElementsDataSourceSortedByType(boolean sortFirstByType) {
        return new ViewChildrenDataSource(this.fCurrentView, sortFirstByType);
    }

    public ViewChildrenDataSource getChildElementsDataSourceForTypesSortedByType(String types, boolean sortFirstByType) {
        return new ViewChildrenDataSource(this.fCurrentView, types, sortFirstByType);
    }

    public boolean next() throws JRException {
        this.fCurrentView = this.currentIndex < this.fViews.size() - 1 ? this.fViews.get(++this.currentIndex) : null;
        return this.fCurrentView != null;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        if ("imagePath".equals(fieldName)) {
            return this.getImagePath();
        }
        if ("viewpoint".equals(fieldName) && this.fCurrentView instanceof IArchimateDiagramModel) {
            return this.getViewpointName();
        }
        return FieldDataFactory.getFieldValue(this.fCurrentView, fieldName);
    }

    public void moveFirst() throws JRException {
        this.currentIndex = -1;
    }

    private String getImagePath() {
        String diagramName = this.fCurrentView.getId() + ".png";
        return System.getProperty("JASPER_IMAGE_PATH") + "/" + diagramName;
    }

    public IDiagramModel getElement() {
        return this.fCurrentView;
    }

    public int size() {
        return this.fViews.size();
    }
}

