/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports.preferences;

import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.jasperreports.JasperReportsPlugin;
import com.archimatetool.jasperreports.preferences.IJasperPreferenceConstants;
import com.archimatetool.jasperreports.preferences.Messages;
import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class JasperReportsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IJasperPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.prefsJasper";
    private Text fUserReportsFolderTextField;

    public JasperReportsPreferencesPage() {
        this.setPreferenceStore(JasperReportsPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_ID);
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Group settingsGroup = new Group(client, 0);
        settingsGroup.setText(Messages.JasperReportsPreferencesPage_0);
        settingsGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.widthHint = 500;
        settingsGroup.setLayoutData((Object)gd);
        Label label = new Label((Composite)settingsGroup, 0);
        label.setText(Messages.JasperReportsPreferencesPage_1);
        this.fUserReportsFolderTextField = UIUtils.createSingleTextControl((Composite)settingsGroup, (int)2048, (boolean)false);
        this.fUserReportsFolderTextField.setLayoutData((Object)new GridData(768));
        Button folderButton = new Button((Composite)settingsGroup, 8);
        folderButton.setText(Messages.JasperReportsPreferencesPage_2);
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String folderPath = JasperReportsPreferencesPage.this.chooseFolderPath();
                if (folderPath != null) {
                    JasperReportsPreferencesPage.this.fUserReportsFolderTextField.setText(folderPath);
                }
            }
        });
        this.setValues();
        return client;
    }

    private String chooseFolderPath() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.JasperReportsPreferencesPage_3);
        dialog.setMessage(Messages.JasperReportsPreferencesPage_4);
        File file = new File(this.fUserReportsFolderTextField.getText());
        if (file.exists()) {
            dialog.setFilterPath(this.fUserReportsFolderTextField.getText());
        }
        return dialog.open();
    }

    private void setValues() {
        this.fUserReportsFolderTextField.setText(this.getPreferenceStore().getString("JRUserReportsFolder"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("JRUserReportsFolder", this.fUserReportsFolderTextField.getText());
        return true;
    }

    protected void performDefaults() {
        this.fUserReportsFolderTextField.setText(JasperReportsPlugin.getInstance().getDefaultUserTemplatesFolder().getAbsolutePath());
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

