/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.commandline;

import com.archimatetool.commandline.ICommandLineProvider;
import com.archimatetool.commandline.Messages;
import com.archimatetool.editor.WorkbenchCleaner;
import com.archimatetool.editor.utils.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;

public class CentralScrutinizer
implements IApplication {
    private Map<ICommandLineProvider, ProviderInfo> providers;

    public Object start(IApplicationContext context) throws Exception {
        try {
            this.registerProviders();
            CommandLine commandLine = this.processOptions();
            if (commandLine.hasOption("help")) {
                this.showHelp();
                if (commandLine.hasOption("pause")) {
                    this.pause();
                }
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = this.runProviders(commandLine);
            return n;
        }
        finally {
            WorkbenchCleaner.cleanConfigOnExit((boolean)false);
        }
    }

    public void stop() {
    }

    private void registerProviders() {
        this.providers = new LinkedHashMap<ICommandLineProvider, ProviderInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("com.archimatetool.commandline.commandlineProvider");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String id = configurationElement.getAttribute("id");
                String name = configurationElement.getAttribute("name");
                String description = configurationElement.getAttribute("description");
                ICommandLineProvider provider = (ICommandLineProvider)configurationElement.createExecutableExtension("class");
                if (id != null && provider != null) {
                    ProviderInfo info = new ProviderInfo(id, StringUtils.isSet((String)name) ? name : id, StringUtils.safeString((String)description));
                    this.providers.put(provider, info);
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }

    private CommandLine processOptions() throws ParseException {
        Options options = this.getCoreOptions();
        options.addOptions(this.getProviderOptions());
        ArrayList<String> args = new ArrayList<String>();
        boolean nextArgument = false;
        String[] stringArray = Platform.getApplicationArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (options.hasOption(arg) || nextArgument) {
                args.add(arg);
            }
            nextArgument = options.hasOption(arg) && options.getOption(arg).hasArg();
            ++n2;
        }
        DefaultParser parser = new DefaultParser();
        return parser.parse(options, args.toArray(new String[args.size()]), false);
    }

    private Options getCoreOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, Messages.CentralScrutinizer_0);
        options.addOption("a", "abortOnException", false, Messages.CentralScrutinizer_1);
        options.addOption("p", "pause", false, Messages.CentralScrutinizer_6);
        return options;
    }

    private Options getProviderOptions() {
        Options options = new Options();
        for (ICommandLineProvider provider : this.providers.keySet()) {
            Options providerOptions = provider.getOptions();
            if (providerOptions == null) continue;
            options.addOptions(providerOptions);
        }
        return options;
    }

    private int runProviders(CommandLine commandLine) {
        Display.getDefault();
        ArrayList<ICommandLineProvider> sortedProviders = new ArrayList<ICommandLineProvider>(this.providers.keySet());
        sortedProviders.sort((p1, p2) -> p1.getPriority() - p2.getPriority());
        for (ICommandLineProvider provider : sortedProviders) {
            try {
                provider.run(commandLine);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!commandLine.hasOption("abortOnException")) continue;
                return -1;
            }
        }
        if (commandLine.hasOption("pause")) {
            this.pause();
        }
        return EXIT_OK;
    }

    private void showHelp() {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out, true);
        System.out.println(Messages.CentralScrutinizer_2);
        System.out.println();
        System.out.println(Messages.CentralScrutinizer_3);
        System.out.println("---------------");
        formatter.printOptions(pw, 140, this.getCoreOptions(), 1, 10);
        System.out.println();
        System.out.println(Messages.CentralScrutinizer_4);
        System.out.println("---------------------");
        ArrayList<ProviderInfo> infos = new ArrayList<ProviderInfo>(this.providers.values());
        infos.sort((info1, info2) -> info1.name.compareToIgnoreCase(info2.name));
        for (ProviderInfo info : infos) {
            System.out.println(" [" + info.name() + "] " + info.description());
        }
        System.out.println();
        System.out.println(Messages.CentralScrutinizer_5);
        System.out.println("--------");
        formatter.printOptions(pw, 140, this.getProviderOptions(), 1, 10);
    }

    private void pause() {
        System.out.println();
        System.out.println(Messages.CentralScrutinizer_7);
        try {
            System.in.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private record ProviderInfo(String id, String name, String description) {
    }
}

