/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.commandline.providers;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.commandline.providers.Messages;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.osgi.util.NLS;

public class SaveModelProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.SaveModelProvider_0;
    static final String OPTION_SAVE_MODEL = "saveModel";

    @Override
    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_SAVE_MODEL).hasArg().argName(Messages.SaveModelProvider_1).desc(Messages.SaveModelProvider_2).build();
        options.addOption(option);
        return options;
    }

    @Override
    public void run(CommandLine commandLine) throws Exception {
        if (commandLine.hasOption(OPTION_SAVE_MODEL)) {
            IArchimateModel model = CommandLineState.getModel();
            if (model == null) {
                throw new IOException(Messages.SaveModelProvider_3);
            }
            String filePath = commandLine.getOptionValue(OPTION_SAVE_MODEL);
            File file = new File(filePath);
            this.saveModel(model, file);
            this.logMessage(NLS.bind((String)Messages.SaveModelProvider_4, (Object)file.getPath()));
        }
    }

    private void saveModel(IArchimateModel model, File file) throws IOException {
        model.setVersion("5.0.0");
        model.setFile(file);
        IArchiveManager archiveManager = (IArchiveManager)model.getAdapter(IArchiveManager.class);
        if (archiveManager == null) {
            archiveManager = IArchiveManager.FACTORY.createArchiveManager((IArchimateModel)model);
            model.setAdapter(IArchiveManager.class, (Object)archiveManager);
        }
        archiveManager.saveModel();
        CommandStack stack = (CommandStack)model.getAdapter(CommandStack.class);
        if (stack != null) {
            stack.markSaveLocation();
        }
    }

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    protected String getLogPrefix() {
        return PREFIX;
    }
}

