/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jdom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderXSDFactory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class JDOMUtils {
    public static Namespace XSI_Namespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    public static Namespace XSI_NamespaceOLD = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2000/10/XMLSchema-instance");
    public static String XSI_SchemaLocation = "schemaLocation";

    public static void write2XMLFile(Document doc, File file) throws IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file);
        outputter.output(doc, (OutputStream)out);
        out.close();
    }

    public static String write2XMLString(Document doc) throws IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        StringWriter out = new StringWriter();
        outputter.output(doc, (Writer)out);
        out.close();
        return out.toString();
    }

    public static Document readXMLFile(File xmlFile, File ... schemaFiles) throws IOException, JDOMException {
        XMLReaderXSDFactory factory = new XMLReaderXSDFactory(schemaFiles);
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)factory);
        JDOMUtils.setFeatures(builder);
        return builder.build((InputStream)new FileInputStream(xmlFile));
    }

    public static Document readXMLFile(File file) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        JDOMUtils.setFeatures(builder);
        return builder.build((InputStream)new FileInputStream(file));
    }

    public static Document readXMLString(String xmlString) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        JDOMUtils.setFeatures(builder);
        return builder.build((Reader)new StringReader(xmlString));
    }

    private static void setFeatures(SAXBuilder builder) {
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
    }
}

