/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.browser;

import com.archimatetool.editor.browser.IBrowserEditorInput;
import com.archimatetool.editor.browser.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class BrowserEditorInput
implements IBrowserEditorInput {
    private String url;
    private String title;
    private boolean jsEnabled = true;
    private boolean externalHostsEnabled = true;
    private boolean fPersistBrowser;

    public BrowserEditorInput(String url) {
        this(url, null);
    }

    public BrowserEditorInput(String url, String title) {
        this.url = url;
        this.title = title;
    }

    @Override
    public void setPersistBrowser(boolean value) {
        this.fPersistBrowser = value;
    }

    @Override
    public void setJavascriptEnabled(boolean value) {
        this.jsEnabled = value;
    }

    @Override
    public boolean getJavascriptEnabled() {
        return this.jsEnabled;
    }

    @Override
    public void setExternalHostsEnabled(boolean value) {
        this.externalHostsEnabled = value;
    }

    @Override
    public boolean getExternalHostsEnabled() {
        return this.externalHostsEnabled;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    public String getName() {
        if (this.title != null) {
            return this.title;
        }
        return this.getURL() == null ? Messages.BrowserEditorInput_0 : this.getURL();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public IPersistableElement getPersistable() {
        if (!this.fPersistBrowser || this.getURL() == null) {
            return null;
        }
        return this;
    }

    public void saveState(IMemento memento) {
        if (this.url != null) {
            memento.putString("url", this.url);
            memento.putString("title", this.title);
            memento.putBoolean("persistBrowser", this.fPersistBrowser);
        }
    }

    public String getFactoryId() {
        return "com.archimatetool.editor.browser.BrowserEditorInputFactory";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BrowserEditorInput)) {
            return false;
        }
        if (this.getURL() == null) {
            return false;
        }
        return this.getURL().equalsIgnoreCase(((BrowserEditorInput)obj).getURL());
    }
}

