/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;

public class PolylineDecoration
extends Polyline
implements RotatableDecoration {
    public static final PointList TRIANGLE_TIP = new PointList();
    private Point location = new Point();
    private PointList template = TRIANGLE_TIP;
    private Transform transform = new Transform();

    static {
        TRIANGLE_TIP.addPoint(-1, 1);
        TRIANGLE_TIP.addPoint(0, 0);
        TRIANGLE_TIP.addPoint(-1, -1);
    }

    public PolylineDecoration() {
        this.setBackgroundColor(ColorConstants.black);
        this.setScale(7.0, 3.0);
    }

    @Override
    public PointList getPoints() {
        if (this.points == null) {
            this.points = new PointList();
            int i = 0;
            while (i < this.template.size()) {
                this.points.addPoint(this.transform.getTransformed(this.template.getPoint(i)));
                ++i;
            }
        }
        return this.points;
    }

    @Override
    public void setLocation(Point p) {
        this.points = null;
        this.bounds = null;
        this.location.setLocation(p);
        this.transform.setTranslation(p.x, p.y);
    }

    public void setTemplate(PointList pl) {
        this.erase();
        this.template = pl;
        this.points = null;
        this.bounds = null;
        this.repaint();
    }

    public void setScale(double x, double y) {
        this.points = null;
        this.bounds = null;
        this.transform.setScale(x, y);
    }

    @Override
    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setRotation(double angle) {
        this.points = null;
        this.bounds = null;
        this.transform.setRotation(angle);
    }

    @Override
    public Rectangle getBounds() {
        return super.getBounds().getExpanded(1, 1);
    }
}

