/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleUses;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.VerticalLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;
import org.eclipse.zest.layouts.progress.ProgressEvent;
import org.eclipse.zest.layouts.progress.ProgressListener;

public class SimpleSWTExample {
    private static final Color BLACK = new Color(0, 0, 0);
    private static final Color NODE_NORMAL_COLOR = new Color(225, 225, 255);
    private static final Color NODE_SELECTED_COLOR = new Color(255, 125, 125);
    private static final Color NODE_ADJACENT_COLOR = new Color(255, 200, 125);
    private static final Color BORDER_NORMAL_COLOR = new Color(0, 0, 0);
    private static final Color BORDER_SELECTED_COLOR = new Color(255, 0, 0);
    private static final Color BORDER_ADJACENT_COLOR = new Color(255, 128, 0);
    private static final Color RELATIONSHIP_COLOR = new Color(192, 192, 225);
    private static final Color RELATIONSHIP_HIGHLIGHT_COLOR = new Color(255, 200, 125);
    private static final String[] NAMES = new String[]{"Peggy", "Rob", "Ian", "Chris", "Simon", "Wendy", "Steven", "Kim", "Neil", "Dave", "John", "Suzanne", "Jody", "Casey", "Bjorn", "Peter", "Erin", "Lisa", "Jennie", "Liz", "Bert", "Ryan", "Nick", "Amy", "Lee", "Me", "You", "Max", "NCI", "OWL", "Ed", "Jamie", "Protege", "Matt", "Bryan", "Pete", "Sam", "Bob", "Katie", "Bill", "Josh", "Davor", "Ken", "Jacob", "Norm", "Jim", "Maya", "Jill", "Kit", "Jo", "Joe", "Andrew", "Charles", "Pat", "Patrick", "Jeremy", "Mike", "Michael", "Patricia", "Marg", "Terry", "Emily", "Ben", "Holly", "Joanna", "Joanne", "Evan", "Tom", "Dan", "Eric", "Corey", "Meghan", "Kevin", "Nina", "Ron", "Daniel", "David", "Jeff", "Nathan", "Amanda", "Phil", "Tricia", "Steph", "Stewart", "Stuart", "Bull", "Lintern", "Callendar", "Thompson", "Rigby", "Adam", "Judith", "Cynthia", "Sarah", "Sara", "Roger", "Andy", "Kris", "Mark", "Shane", "Spence", "Ivy", "Ivanna", "Julie", "Justin", "Emile", "Toby", "Robin", "Rich", "Kathy", "Cathy", "Nicky", "Ricky", "Danny", "Anne", "Ann", "Jen", "Robert", "Calvin", "Alvin", "Scott", "Kumar"};
    private static final int INITIAL_PANEL_WIDTH = 800;
    private static final int INITIAL_PANEL_HEIGHT = 600;
    private static final double INITIAL_NODE_WIDTH = 20.0;
    private static final double INITIAL_NODE_HEIGHT = 15.0;
    protected static ArrayList algorithms = new ArrayList();
    protected static ArrayList algorithmNames = new ArrayList();
    protected static ArrayList algorithmAnimates = new ArrayList();
    private boolean animate;
    private static boolean continuous = false;
    private static boolean asynchronously = false;
    private Shell mainShell;
    private Composite mainComposite;
    private List entities;
    private List relationships;
    private ToolBar toolBar;
    private Label lblProgress;
    private LayoutAlgorithm currentLayoutAlgorithm;
    protected SimpleNode selectedEntity;
    protected SimpleNode hoverEntity;
    protected Point mouseDownPoint;
    protected Point selectedEntityPositionAtMouseDown;
    private long idCount;
    IProgressMonitor progressMonitor;
    ProgressMonitorDialog pmd;
    boolean GUI_UPDATING;
    static int lastUpdateCall = 0;
    private int repeats;
    static Display display = null;

    public SimpleSWTExample(Display display) {
        algorithms.add(new SpringLayoutAlgorithm(1));
        algorithms.add(new TreeLayoutAlgorithm(0));
        algorithms.add(new HorizontalTreeLayoutAlgorithm(0));
        algorithms.add(new RadialLayoutAlgorithm(0));
        algorithms.add(new GridLayoutAlgorithm(0));
        algorithms.add(new HorizontalLayoutAlgorithm(0));
        algorithms.add(new VerticalLayoutAlgorithm(0));
        algorithmNames.add("Spring");
        algorithmNames.add("Fade");
        algorithmNames.add("Tree - V");
        algorithmNames.add("Tree - H");
        algorithmNames.add("Radial");
        algorithmNames.add("Grid");
        algorithmNames.add("Horizontal");
        algorithmNames.add("Vertical");
        algorithmAnimates.add(Boolean.TRUE);
        algorithmAnimates.add(Boolean.TRUE);
        algorithmAnimates.add(Boolean.FALSE);
        algorithmAnimates.add(Boolean.FALSE);
        algorithmAnimates.add(Boolean.FALSE);
        algorithmAnimates.add(Boolean.FALSE);
        algorithmAnimates.add(Boolean.FALSE);
        algorithmAnimates.add(Boolean.FALSE);
        this.animate = true;
        this.idCount = 0L;
        this.progressMonitor = null;
        this.pmd = null;
        this.GUI_UPDATING = false;
        this.repeats = 0;
        this.mainShell = new Shell(display);
        this.mainShell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                SimpleSWTExample.this.mainShell.layout(true);
            }
        });
        GridLayout gridLayout = new GridLayout(1, true);
        this.mainShell.setLayout((Layout)gridLayout);
        GridData toolbarGridData = new GridData(64, 2, true, true);
        this.toolBar = new ToolBar((Composite)this.mainShell, 256);
        this.toolBar.setLayoutData((Object)toolbarGridData);
        this.toolBar.setLayout((Layout)new FillLayout(256));
        GridData progressGridData = new GridData(64, 8, true, false);
        progressGridData.widthHint = 300;
        this.lblProgress = new Label((Composite)this.mainShell, 0);
        this.lblProgress.setLayoutData((Object)progressGridData);
        this.lblProgress.setText("Progress: ");
        int i = 0;
        while (i < algorithms.size()) {
            final LayoutAlgorithm algorithm = (LayoutAlgorithm)algorithms.get(i);
            String algorithmName = (String)algorithmNames.get(i);
            final boolean algorithmAnimate = (Boolean)algorithmAnimates.get(i);
            ToolItem algorithmButton = new ToolItem(this.toolBar, 8);
            algorithmButton.setText(algorithmName);
            new ToolItem(this.toolBar, 2);
            algorithmButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleSWTExample.this.currentLayoutAlgorithm = algorithm;
                    algorithm.setEntityAspectRatio((double)SimpleSWTExample.this.mainComposite.getClientArea().width / (double)SimpleSWTExample.this.mainComposite.getClientArea().height);
                    SimpleSWTExample.this.animate = algorithmAnimate;
                    SimpleSWTExample.this.performLayout(false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        ToolItem redrawButton = new ToolItem(this.toolBar, 8);
        redrawButton.setText("Redraw");
        redrawButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleSWTExample.this.mainComposite.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem stopButton = new ToolItem(this.toolBar, 8);
        stopButton.setText("Stop");
        stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleSWTExample.this.currentLayoutAlgorithm.stop();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem continuousButton = new ToolItem(this.toolBar, 32);
        continuousButton.setText("Continuous");
        continuousButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleSWTExample.this.setContinuous();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ToolItem asynchronousButton = new ToolItem(this.toolBar, 32);
        asynchronousButton.setText("Asynchronous");
        asynchronousButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleSWTExample.this.setAsynchronously();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createMainPanel();
        SimpleNode.setNodeColors(NODE_NORMAL_COLOR, BORDER_NORMAL_COLOR, NODE_SELECTED_COLOR, NODE_ADJACENT_COLOR, BORDER_SELECTED_COLOR, BORDER_ADJACENT_COLOR);
        SimpleRelationship.setDefaultColor(RELATIONSHIP_COLOR);
        SimpleRelationship.setDefaultHighlightColor(RELATIONSHIP_HIGHLIGHT_COLOR);
        this.createTreeGraph(4, 3, false);
        this.mainShell.pack();
    }

    public void setAsynchronously() {
        asynchronously = !asynchronously;
    }

    public void setContinuous() {
        continuous = !continuous;
    }

    private void performLayout(boolean placeRandomly) {
        if (this.currentLayoutAlgorithm.isRunning()) {
            throw new RuntimeException("Layout is already running");
        }
        if (placeRandomly) {
            this.placeRandomly();
        }
        ProgressListener progressListener = new ProgressListener(){
            int lastStep = 0;

            @Override
            public void progressUpdated(ProgressEvent e) {
                if (asynchronously) {
                    if (!SimpleSWTExample.this.mainComposite.isDisposed()) {
                        Display.getDefault().asyncExec((Runnable)new progressSync(1, e));
                        if (!SimpleSWTExample.this.GUI_UPDATING) {
                            SimpleSWTExample.this.GUI_UPDATING = true;
                            Display.getDefault().asyncExec((Runnable)new progressSync(4, e));
                        }
                    }
                } else if (!SimpleSWTExample.this.mainComposite.isDisposed()) {
                    new progressSync(1, e).run();
                }
            }

            @Override
            public void progressStarted(ProgressEvent e) {
                if (asynchronously) {
                    if (!SimpleSWTExample.this.mainComposite.isDisposed()) {
                        Display.getDefault().asyncExec((Runnable)new progressSync(2, e));
                    }
                } else if (!SimpleSWTExample.this.mainComposite.isDisposed()) {
                    new progressSync(2, e).run();
                }
            }

            @Override
            public void progressEnded(ProgressEvent e) {
                if (asynchronously) {
                    if (!SimpleSWTExample.this.mainComposite.isDisposed()) {
                        Display.getDefault().asyncExec((Runnable)new progressSync(3, e));
                    }
                } else if (!SimpleSWTExample.this.mainComposite.isDisposed()) {
                    new progressSync(3, e).run();
                }
                SimpleSWTExample.this.currentLayoutAlgorithm.removeProgressListener(this);
                Display.getDefault().asyncExec((Runnable)new progressSync(1, e));
            }

            class progressSync
            implements Runnable {
                public static final int PROGRESS_UPDATED = 1;
                public static final int PROGRESS_STARTED = 2;
                public static final int PROGRESS_ENDED = 3;
                public static final int UPDATE_GUI = 4;
                private int progressState = -1;
                private ProgressEvent e;

                public progressSync(int progressState, ProgressEvent e) {
                    this.progressState = progressState;
                    this.e = e;
                }

                @Override
                public void run() {
                    switch (this.progressState) {
                        case 2: {
                            if (continuous) break;
                            (this).SimpleSWTExample.this.pmd = new ProgressMonitorDialog(SimpleSWTExample.this.getShell());
                            (this).SimpleSWTExample.this.progressMonitor = (this).SimpleSWTExample.this.pmd.getProgressMonitor();
                            (this).SimpleSWTExample.this.pmd.open();
                            (this).SimpleSWTExample.this.progressMonitor.beginTask("Layout Running...", this.e.getTotalNumberOfSteps());
                            break;
                        }
                        case 1: {
                            if (continuous) break;
                            (this).SimpleSWTExample.this.progressMonitor.worked(this.e.getStepsCompleted() - lastStep);
                            lastStep = this.e.getStepsCompleted();
                            break;
                        }
                        case 3: {
                            if (!continuous) {
                                (this).SimpleSWTExample.this.progressMonitor.done();
                                (this).SimpleSWTExample.this.pmd.close();
                            }
                            SimpleSWTExample.this.updateGUI();
                            (this).SimpleSWTExample.this.mainShell.redraw();
                            break;
                        }
                        case 4: {
                            SimpleSWTExample.this.updateGUI();
                            (this).SimpleSWTExample.this.GUI_UPDATING = false;
                        }
                    }
                    (this).SimpleSWTExample.this.mainComposite.redraw();
                }
            }
        };
        this.currentLayoutAlgorithm.addProgressListener(progressListener);
        try {
            LayoutEntity[] layoutEntities = new LayoutEntity[this.entities.size()];
            this.entities.toArray(layoutEntities);
            LayoutRelationship[] layoutRelationships = new LayoutRelationship[this.relationships.size()];
            this.relationships.toArray(layoutRelationships);
            this.currentLayoutAlgorithm.applyLayout(layoutEntities, layoutRelationships, 0.0, 0.0, this.mainComposite.getClientArea().width - 30, this.mainComposite.getClientArea().height - 17, asynchronously, continuous);
            if (!this.animate) {
                this.updateGUI();
            }
        }
        catch (InvalidLayoutConfiguration e) {
            e.printStackTrace();
        }
    }

    private Shell getShell() {
        return this.mainShell;
    }

    private void createMainPanel() {
        this.mainComposite = new Canvas((Composite)this.mainShell, 262144);
        GridData mainGridData = new GridData(256, 16, true, true);
        mainGridData.widthHint = 800;
        mainGridData.heightHint = 600;
        this.mainComposite.setLayoutData((Object)mainGridData);
        this.mainComposite.addPaintListener((PaintListener)new GraphPaintListener());
        this.mainComposite.setBackground(new Color(255, 255, 255));
        this.mainComposite.setLayout(null);
        this.mainComposite.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (SimpleSWTExample.this.selectedEntity == null) {
                    SimpleNode oldEntity = SimpleSWTExample.this.hoverEntity;
                    SimpleSWTExample.this.hoverEntity = null;
                    Iterator iter = SimpleSWTExample.this.entities.iterator();
                    while (iter.hasNext() && SimpleSWTExample.this.selectedEntity == null) {
                        double h;
                        double w;
                        double y;
                        SimpleNode entity = (SimpleNode)iter.next();
                        double x = entity.getX();
                        Rectangle rect = new Rectangle((int)x, (int)(y = entity.getY()), (int)(w = entity.getWidth()), (int)(h = entity.getHeight()));
                        if (!rect.contains(e.x, e.y)) continue;
                        SimpleSWTExample.this.hoverEntity = entity;
                        SimpleSWTExample.this.hoverEntity.ignoreInLayout(true);
                        SimpleSWTExample.this.hoverEntity.setSelected();
                        break;
                    }
                    if (oldEntity != null && oldEntity != SimpleSWTExample.this.hoverEntity) {
                        oldEntity.ignoreInLayout(false);
                        oldEntity.setUnSelected();
                    }
                }
            }
        });
        this.mainComposite.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                SimpleSWTExample.this.selectedEntity = null;
                SimpleSWTExample.this.hoverEntity = null;
                Iterator iter = SimpleSWTExample.this.entities.iterator();
                while (iter.hasNext() && SimpleSWTExample.this.selectedEntity == null) {
                    double h;
                    double w;
                    double y;
                    SimpleNode entity = (SimpleNode)iter.next();
                    double x = entity.getX();
                    Rectangle rect = new Rectangle((int)x, (int)(y = entity.getY()), (int)(w = entity.getWidth()), (int)(h = entity.getHeight()));
                    if (!rect.contains(e.x, e.y)) continue;
                    SimpleSWTExample.this.selectedEntity = entity;
                }
                if (SimpleSWTExample.this.selectedEntity != null) {
                    SimpleSWTExample.this.mouseDownPoint = new Point(e.x, e.y);
                    SimpleSWTExample.this.selectedEntityPositionAtMouseDown = new Point((int)SimpleSWTExample.this.selectedEntity.getX(), (int)SimpleSWTExample.this.selectedEntity.getY());
                    SimpleSWTExample.this.selectedEntity.ignoreInLayout(true);
                    SimpleSWTExample.this.selectedEntity.setSelected();
                } else {
                    SimpleSWTExample.this.mouseDownPoint = null;
                    SimpleSWTExample.this.selectedEntityPositionAtMouseDown = null;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (SimpleSWTExample.this.selectedEntity != null) {
                    SimpleSWTExample.this.selectedEntity.ignoreInLayout(false);
                    SimpleSWTExample.this.selectedEntity.setUnSelected();
                    List relatedNodes = SimpleSWTExample.this.selectedEntity.getRelatedEntities();
                    for (SimpleNode element : relatedNodes) {
                        element.setUnSelected();
                    }
                    SimpleRelationship[] rels = SimpleSWTExample.this.selectedEntity.getRelationships();
                    int i = 0;
                    while (i < rels.length) {
                        rels[i].resetLineWidth();
                        ++i;
                    }
                }
                SimpleSWTExample.this.selectedEntity = null;
                SimpleSWTExample.this.mouseDownPoint = null;
                SimpleSWTExample.this.selectedEntityPositionAtMouseDown = null;
            }
        });
        this.mainComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SimpleSWTExample.this.currentLayoutAlgorithm != null) {
                    SimpleSWTExample.this.currentLayoutAlgorithm.stop();
                }
            }
        });
        this.mainComposite.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (SimpleSWTExample.this.selectedEntity != null && SimpleSWTExample.this.mouseDownPoint != null) {
                    double dx = e.x - SimpleSWTExample.this.mouseDownPoint.x;
                    double dy = e.y - SimpleSWTExample.this.mouseDownPoint.y;
                    SimpleSWTExample.this.selectedEntity.setLocation((double)SimpleSWTExample.this.selectedEntityPositionAtMouseDown.x + dx, (double)SimpleSWTExample.this.selectedEntityPositionAtMouseDown.y + dy);
                    SimpleSWTExample.this.mainComposite.redraw();
                }
            }
        });
    }

    private void createTreeGraph(int maxLevels, int maxChildren, boolean random) {
        this.entities = new ArrayList();
        this.relationships = new ArrayList();
        SimpleNode root = this.createSimpleNode(this.getNextID());
        this.entities.add(root);
        SimpleNode root2 = this.createSimpleNode(this.getNextID());
        this.entities.add(root2);
        SimpleNode currentParent = this.createSimpleNode(this.getNextID());
        this.entities.add(currentParent);
        SimpleRelationship rel = new SimpleRelationship(root, currentParent, false);
        root.addRelationship(rel);
        currentParent.addRelationship(rel);
        this.relationships.add(rel);
        rel = new SimpleRelationship(root2, currentParent, false);
        root2.addRelationship(rel);
        currentParent.addRelationship(rel);
        this.relationships.add(rel);
        int levels = random ? (int)(Math.random() * (double)maxLevels + 1.0) : maxLevels;
        this.createTreeGraphRecursive(currentParent, maxChildren, levels, 1, random);
    }

    private void createTreeGraphRecursive(SimpleNode currentParentNode, int maxChildren, int maxLevel, int level, boolean random) {
        if (level > maxLevel) {
            return;
        }
        int numChildren = random ? (int)(Math.random() * (double)maxChildren + 1.0) : maxChildren;
        int child = 0;
        while (child < numChildren) {
            SimpleNode childNode = this.createSimpleNode(this.getNextID());
            this.entities.add(childNode);
            SimpleRelationship rel = new SimpleRelationship(currentParentNode, childNode, false);
            childNode.addRelationship(rel);
            currentParentNode.addRelationship(rel);
            this.relationships.add(rel);
            SimpleRelationship.setDefaultSize(2);
            this.createTreeGraphRecursive(childNode, maxChildren, maxLevel, level + 1, random);
            ++child;
        }
    }

    private String getNextID() {
        if (this.idCount >= (long)NAMES.length) {
            this.idCount = 0L;
            ++this.repeats;
        }
        Object id = NAMES[(int)this.idCount];
        if (this.repeats > 0) {
            id = (String)id + "_" + this.repeats;
        }
        ++this.idCount;
        return id;
    }

    private void placeRandomly() {
        for (SimpleNode simpleNode : this.entities) {
            double x = Math.random() * 800.0 - 20.0;
            double y = Math.random() * 600.0 - 15.0;
            simpleNode.setLocationInLayout(x, y);
        }
    }

    private SimpleNode createSimpleNode(String name) {
        SimpleNode simpleNode = new SimpleNode(name);
        int w = name.length() * 8;
        simpleNode.setSizeInLayout(Math.max((double)w, 20.0), 15.0);
        return simpleNode;
    }

    private void updateGUI() {
        if (!this.mainComposite.isDisposed()) {
            this.mainComposite.redraw();
        }
    }

    public static void main(String[] args) {
        display = Display.getDefault();
        SimpleSWTExample simpleSWTExample = new SimpleSWTExample(display);
        Shell shell = simpleSWTExample.getShell();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private class GraphPaintListener
    implements PaintListener {
        long lastPaint;

        private GraphPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            Image imageBuffer;
            Date date = new Date();
            long currentTime = date.getTime();
            if (currentTime - this.lastPaint < 40L) {
                return;
            }
            this.lastPaint = currentTime;
            if (Display.getDefault() == null || e.width == 0 || e.height == 0) {
                return;
            }
            long startTime = date.getTime();
            try {
                imageBuffer = new Image((Device)Display.getDefault(), e.width, e.height);
            }
            catch (SWTError noMoreHandles) {
                Object imageBuffer2 = null;
                noMoreHandles.printStackTrace();
                return;
            }
            catch (IllegalArgumentException tooBig) {
                Object imageBuffer3 = null;
                tooBig.printStackTrace();
                return;
            }
            GC gcBuffer = new GC((Drawable)imageBuffer);
            for (SimpleRelationship rel : SimpleSWTExample.this.relationships) {
                SimpleNode src = (SimpleNode)rel.getSourceInLayout();
                SimpleNode dest = (SimpleNode)rel.getDestinationInLayout();
                if (src.equals(SimpleSWTExample.this.selectedEntity)) {
                    dest.setAdjacent();
                    rel.setSelected();
                } else if (dest.equals(SimpleSWTExample.this.selectedEntity)) {
                    src.setAdjacent();
                    rel.setSelected();
                } else {
                    rel.setUnSelected();
                }
                if (rel.getBendPoints() != null && rel.getBendPoints().length > 0) {
                    src = this.drawBendPoints(rel, gcBuffer);
                }
                double srcX = src.getX() + src.getWidth() / 2.0;
                double srcY = src.getY() + src.getHeight() / 2.0;
                double destX = dest.getX() + dest.getWidth() / 2.0;
                double destY = dest.getY() + dest.getHeight() / 2.0;
                this.drawEdge(srcX, srcY, destX, destY, rel, gcBuffer);
            }
            for (SimpleNode entity : SimpleSWTExample.this.entities) {
                String name = entity.toString();
                Point textSize = gcBuffer.stringExtent(name);
                int entityX = (int)entity.getX();
                int entityY = (int)entity.getY();
                int entityWidth = Math.max((int)entity.getWidth(), textSize.x + 8);
                int entityHeight = Math.max((int)entity.getHeight(), textSize.y + 2);
                gcBuffer.setBackground((Color)entity.getColor());
                gcBuffer.fillRoundRectangle(entityX, entityY, entityWidth, entityHeight, 8, 8);
                int x = (int)((double)entityX + (double)entityWidth / 2.0) - textSize.x / 2;
                gcBuffer.setForeground(BLACK);
                gcBuffer.drawString(name, x, entityY);
                gcBuffer.setForeground((Color)entity.getBorderColor());
                gcBuffer.setLineWidth(entity.getBorderWidth());
                gcBuffer.drawRoundRectangle(entityX, entityY, entityWidth, entityHeight, 8, 8);
            }
            e.gc.drawImage(imageBuffer, 0, 0);
            imageBuffer.dispose();
            gcBuffer.dispose();
            long time = date.getTime() - startTime;
        }

        private void drawEdge(double srcX, double srcY, double destX, double destY, SimpleRelationship rel, GC gcBuffer) {
            gcBuffer.setForeground((Color)rel.getColor());
            gcBuffer.setLineWidth(rel.getLineWidth());
            gcBuffer.drawLine((int)srcX, (int)srcY, (int)destX, (int)destY);
        }

        private SimpleNode drawBendPoints(SimpleRelationship rel, GC gcBuffer) {
            LayoutBendPoint[] bendPoints = rel.getBendPoints();
            SimpleNode startEntity = (SimpleNode)rel.getSourceInLayout();
            SimpleNode destEntity = null;
            double srcX = startEntity.getX() + startEntity.getWidth() / 2.0;
            double srcY = startEntity.getY() + startEntity.getHeight() / 2.0;
            int i = 1;
            while (i < bendPoints.length - 1) {
                LayoutBendPoint bp = bendPoints[i];
                destEntity = new SimpleNode("dummy", bp.getX(), bp.getY(), 0.01, 0.01);
                this.drawEdge(srcX, srcY, bp.getX(), bp.getY(), rel, gcBuffer);
                startEntity = destEntity;
                srcX = startEntity.getX();
                srcY = startEntity.getY();
                ++i;
            }
            return destEntity;
        }
    }
}

