/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.xmlexchange.commandline;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.xmlexchange.commandline.Messages;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.osgi.util.NLS;
import org.opengroup.archimate.xmlexchange.XMLModelExporter;
import org.opengroup.archimate.xmlexchange.XMLValidator;

public class ExportXMLProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.ExportXMLProvider_0;
    static final String OPTION_EXPORT_XML = "xmlexchange.export";
    static final String OPTION_EXPORT_XML_FOLDERS = "xmlexchange.exportFolders";
    static final String OPTION_EXPORT_XML_LANGUAGE = "xmlexchange.exportLang";

    public void run(CommandLine commandLine) throws Exception {
        if (!this.hasCorrectOptions(commandLine)) {
            return;
        }
        IArchimateModel model = CommandLineState.getModel();
        if (model == null) {
            throw new IOException(Messages.ExportXMLProvider_1);
        }
        String value = commandLine.getOptionValue(OPTION_EXPORT_XML);
        if (!StringUtils.isSet((String)value)) {
            this.logError(Messages.ExportXMLProvider_2);
            return;
        }
        File outputFile = new File(value);
        XMLModelExporter exporter = new XMLModelExporter();
        exporter.setSaveOrganisation(commandLine.hasOption(OPTION_EXPORT_XML_FOLDERS));
        exporter.setLanguageCode(commandLine.getOptionValue(OPTION_EXPORT_XML_LANGUAGE));
        this.logMessage(NLS.bind((String)Messages.ExportXMLProvider_3, (Object)model.getName(), (Object)outputFile.getPath()));
        exporter.exportModel(model, outputFile);
        this.logMessage(Messages.ExportXMLProvider_4);
        this.logMessage(Messages.ExportXMLProvider_5);
        XMLValidator validator = new XMLValidator();
        validator.validateXML(outputFile);
        this.logMessage(Messages.ExportXMLProvider_6);
    }

    protected String getLogPrefix() {
        return PREFIX;
    }

    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_EXPORT_XML).hasArg().argName(Messages.ExportXMLProvider_7).desc(Messages.ExportXMLProvider_8).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_EXPORT_XML_FOLDERS).desc(Messages.ExportXMLProvider_9).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_EXPORT_XML_LANGUAGE).hasArg().argName(Messages.ExportXMLProvider_10).desc(Messages.ExportXMLProvider_11).build();
        options.addOption(option);
        return options;
    }

    private boolean hasCorrectOptions(CommandLine commandLine) {
        return commandLine.hasOption(OPTION_EXPORT_XML);
    }
}

