/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.xmlexchange.commandline;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.xmlexchange.commandline.Messages;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.osgi.util.NLS;
import org.opengroup.archimate.xmlexchange.XMLModelImporter;
import org.opengroup.archimate.xmlexchange.XMLValidator;

public class ImportXMLProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.ImportXMLProvider_0;
    static final String OPTION_IMPORT_XML = "xmlexchange.import";

    public void run(CommandLine commandLine) throws Exception {
        if (!this.hasCorrectOptions(commandLine)) {
            return;
        }
        String value = commandLine.getOptionValue(OPTION_IMPORT_XML);
        if (!StringUtils.isSet((String)value)) {
            this.logError(Messages.ImportXMLProvider_1);
            return;
        }
        File importFile = new File(value);
        if (!importFile.exists()) {
            this.logError(NLS.bind((String)Messages.ImportXMLProvider_2, (Object)value));
            return;
        }
        this.logMessage(Messages.ImportXMLProvider_3);
        XMLValidator validator = new XMLValidator();
        validator.validateXML(importFile);
        this.logMessage(Messages.ImportXMLProvider_4);
        this.logMessage(NLS.bind((String)Messages.ImportXMLProvider_5, (Object)importFile.getPath()));
        XMLModelImporter importer = new XMLModelImporter();
        IArchimateModel model = importer.createArchiMateModel(importFile);
        if (model == null) {
            throw new IOException(Messages.ImportXMLProvider_6);
        }
        IArchiveManager archiveManager = IArchiveManager.FACTORY.createArchiveManager((IArchimateModel)model);
        model.setAdapter(IArchiveManager.class, (Object)archiveManager);
        CommandStack cmdStack = new CommandStack();
        model.setAdapter(CommandStack.class, (Object)cmdStack);
        CommandLineState.setModel((IArchimateModel)model);
        this.logMessage(Messages.ImportXMLProvider_7);
    }

    protected String getLogPrefix() {
        return PREFIX;
    }

    public int getPriority() {
        return 20;
    }

    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_IMPORT_XML).hasArg().argName(Messages.ImportXMLProvider_8).desc(Messages.ImportXMLProvider_9).build();
        options.addOption(option);
        return options;
    }

    private boolean hasCorrectOptions(CommandLine commandLine) {
        return commandLine.hasOption(OPTION_IMPORT_XML);
    }
}

