/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.Logger;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import com.archimatetool.modelimporter.AbstractImporter;
import com.archimatetool.modelimporter.ImportException;
import com.archimatetool.modelimporter.Messages;
import com.archimatetool.modelimporter.ModelImporter;
import com.archimatetool.modelimporter.StatusMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;

class ConceptImporter
extends AbstractImporter {
    ConceptImporter(ModelImporter importer) {
        super(importer);
    }

    IArchimateConcept importConcept(IArchimateConcept importedConcept) throws ImportException {
        boolean createdNewConcept = false;
        IArchimateConcept targetConcept = this.findObjectInTargetModel(importedConcept);
        if (targetConcept == null) {
            targetConcept = this.cloneObject(importedConcept);
            createdNewConcept = true;
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, targetConcept instanceof IArchimateElement ? Messages.ConceptImporter_0 : Messages.ConceptImporter_1, targetConcept);
        } else if (this.shouldUpdate()) {
            this.updateObject((EObject)importedConcept, (EObject)targetConcept);
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, targetConcept instanceof IArchimateElement ? Messages.ConceptImporter_2 : Messages.ConceptImporter_3, targetConcept);
        } else {
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, targetConcept instanceof IArchimateElement ? Messages.ConceptImporter_4 : Messages.ConceptImporter_5, targetConcept);
        }
        if (this.shouldUpdate() || createdNewConcept) {
            if (importedConcept instanceof IArchimateRelationship) {
                this.setRelationshipEnds((IArchimateRelationship)importedConcept, (IArchimateRelationship)targetConcept);
            }
            this.addToParentFolder((IArchimateModelObject)importedConcept, (IArchimateModelObject)targetConcept);
            this.addCommand(new UpdateProfilesCommand((IProfiles)importedConcept, (IProfiles)targetConcept));
        }
        return targetConcept;
    }

    private void setRelationshipEnds(IArchimateRelationship importedRelationship, IArchimateRelationship targetRelationship) throws ImportException {
        IArchimateConcept target;
        IArchimateConcept source = this.findObjectInTargetModel(importedRelationship.getSource());
        if (source == null) {
            source = this.importConcept(importedRelationship.getSource());
        }
        if ((target = this.findObjectInTargetModel(importedRelationship.getTarget())) == null) {
            target = this.importConcept(importedRelationship.getTarget());
        }
        this.addCommand(new SetRelationshipEndsCommand(targetRelationship, source, target));
    }

    private static class SetRelationshipEndsCommand
    extends Command {
        private IArchimateRelationship relationship;
        private IArchimateConcept sourceConcept;
        private IArchimateConcept targetConcept;
        private IArchimateConcept oldSourceConcept;
        private IArchimateConcept oldTargetConcept;

        private SetRelationshipEndsCommand(IArchimateRelationship relationship, IArchimateConcept sourceConcept, IArchimateConcept targetConcept) {
            this.relationship = relationship;
            this.sourceConcept = sourceConcept;
            this.targetConcept = targetConcept;
            this.oldSourceConcept = relationship.getSource();
            this.oldTargetConcept = relationship.getTarget();
        }

        public void execute() {
            this.relationship.setSource(this.sourceConcept);
            this.relationship.setTarget(this.targetConcept);
        }

        public void undo() {
            this.relationship.setSource(this.oldSourceConcept);
            this.relationship.setTarget(this.oldTargetConcept);
        }

        public boolean canExecute() {
            return !this.sourceConcept.equals(this.oldSourceConcept) || !this.targetConcept.equals(this.oldTargetConcept);
        }

        public void dispose() {
            this.relationship = null;
            this.sourceConcept = null;
            this.targetConcept = null;
            this.oldSourceConcept = null;
            this.oldTargetConcept = null;
        }
    }

    private class UpdateProfilesCommand
    extends Command {
        private IProfiles importedObject;
        private IProfiles targetObject;
        private List<IProfile> oldProfiles;
        private List<IProfile> newProfiles;

        private UpdateProfilesCommand(IProfiles importedObject, IProfiles targetObject) {
            this.importedObject = importedObject;
            this.targetObject = targetObject;
            this.oldProfiles = new ArrayList<IProfile>((Collection<IProfile>)targetObject.getProfiles());
        }

        public void execute() {
            this.targetObject.getProfiles().clear();
            for (IProfile importedProfile : this.importedObject.getProfiles()) {
                try {
                    IProfile targetProfile = ConceptImporter.this.findObjectInTargetModel(importedProfile);
                    if (targetProfile != null) {
                        this.targetObject.getProfiles().add((Object)targetProfile);
                        continue;
                    }
                    Logger.logError((String)"Could not get referenced Profile!");
                }
                catch (ImportException ex) {
                    Logger.logError((String)"Error getting referenced Profile!", (Throwable)ex);
                    ex.printStackTrace();
                }
            }
            this.newProfiles = new ArrayList<IProfile>((Collection<IProfile>)this.targetObject.getProfiles());
        }

        public void undo() {
            this.targetObject.getProfiles().clear();
            this.targetObject.getProfiles().addAll(this.oldProfiles);
        }

        public void redo() {
            this.targetObject.getProfiles().clear();
            this.targetObject.getProfiles().addAll(this.newProfiles);
        }

        public boolean canExecute() {
            return !EcoreUtil.equals((List)this.importedObject.getProfiles(), this.oldProfiles);
        }

        public void dispose() {
            this.importedObject = null;
            this.targetObject = null;
            this.oldProfiles = null;
            this.newProfiles = null;
        }
    }
}

