/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.model.FolderType;
import com.archimatetool.model.IFolder;
import com.archimatetool.modelimporter.AbstractImporter;
import com.archimatetool.modelimporter.ImportException;
import com.archimatetool.modelimporter.Messages;
import com.archimatetool.modelimporter.ModelImporter;
import com.archimatetool.modelimporter.StatusMessage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

class FolderImporter
extends AbstractImporter {
    FolderImporter(ModelImporter importer) {
        super(importer);
    }

    IFolder importFolder(IFolder importedFolder) throws ImportException {
        boolean createdNewFolder = false;
        IFolder targetFolder = this.findObjectInTargetModel(importedFolder);
        if (targetFolder == null) {
            targetFolder = this.getTargetModel().getFolder(importedFolder.getType());
            if (targetFolder == null) {
                targetFolder = this.cloneObject(importedFolder);
                createdNewFolder = true;
                this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.FolderImporter_0, targetFolder);
            } else if (this.shouldUpdateAll()) {
                this.updateObject((EObject)importedFolder, (EObject)targetFolder);
                this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.FolderImporter_1, targetFolder);
            }
        } else if (this.isUserFolder(importedFolder) && this.shouldUpdate() || this.isTopLevelFolder(importedFolder) && this.shouldUpdateAll()) {
            this.updateObject((EObject)importedFolder, (EObject)targetFolder);
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.FolderImporter_1, targetFolder);
        } else if (this.isUserFolder(importedFolder)) {
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.FolderImporter_2, targetFolder);
        }
        if ((createdNewFolder || this.shouldUpdate()) && this.isUserFolder(importedFolder)) {
            this.addToParentFolder(importedFolder, targetFolder);
        }
        return targetFolder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addToParentFolder(IFolder importedFolder, IFolder targetFolder) throws ImportException {
        IFolder importedParentFolder = (IFolder)importedFolder.eContainer();
        if (this.isUserFolder(importedParentFolder)) {
            IFolder targetParentFolder = this.findObjectInTargetModel(importedParentFolder);
            if (targetParentFolder == null) throw new ImportException("Target parent folder was null");
            this.addCommand(new AddFolderCommand(targetParentFolder, targetFolder));
            return;
        } else {
            IFolder targetParentFolder = this.getTargetModel().getFolder(importedParentFolder.getType());
            this.addCommand(new AddFolderCommand(targetParentFolder, targetFolder));
        }
    }

    private boolean isTopLevelFolder(IFolder folder) {
        return folder.getType() != FolderType.USER;
    }

    private boolean isUserFolder(IFolder folder) {
        return folder.getType() == FolderType.USER;
    }

    private static class AddFolderCommand
    extends Command {
        private IFolder parent;
        private IFolder subFolder;
        IFolder oldParent;
        int oldPosition;

        private AddFolderCommand(IFolder parent, IFolder subFolder) {
            this.parent = parent;
            this.subFolder = subFolder;
            this.oldParent = (IFolder)subFolder.eContainer();
        }

        public boolean canExecute() {
            return !this.parent.getFolders().contains((Object)this.subFolder);
        }

        public void undo() {
            if (this.oldParent != null) {
                this.oldParent.getFolders().add(this.oldPosition, (Object)this.subFolder);
            } else {
                this.parent.getFolders().remove((Object)this.subFolder);
            }
        }

        public void execute() {
            if (this.oldParent != null) {
                this.oldPosition = this.oldParent.getFolders().indexOf((Object)this.subFolder);
            }
            this.parent.getFolders().add((Object)this.subFolder);
        }

        public void dispose() {
            this.parent = null;
            this.subFolder = null;
            this.oldParent = null;
        }
    }
}

