/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.modelimporter;

import com.archimatetool.editor.diagram.commands.DiagramCommandFactory;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.ICloneable;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IFeature;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.modelimporter.ConceptImporter;
import com.archimatetool.modelimporter.DefaultObjectMatcher;
import com.archimatetool.modelimporter.FolderImporter;
import com.archimatetool.modelimporter.IObjectMatcher;
import com.archimatetool.modelimporter.ImportException;
import com.archimatetool.modelimporter.Messages;
import com.archimatetool.modelimporter.ProfileImporter;
import com.archimatetool.modelimporter.StatusMessage;
import com.archimatetool.modelimporter.ViewImporter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.osgi.util.NLS;

public class ModelImporter {
    private boolean update;
    private boolean updateAll;
    private boolean updateFolderStructure = true;
    private IArchimateModel importedModel;
    private IArchimateModel targetModel;
    private IObjectMatcher objectMatcher;
    private List<StatusMessage> statusMessages;
    private NonNotifyingCompoundCommand compoundCommand;
    private static Set<EAttribute> IGNORED_EATTRIBUTES = Set.of(IArchimatePackage.Literals.DIAGRAM_MODEL_IMAGE_PROVIDER__IMAGE_PATH, IArchimatePackage.Literals.ARCHIMATE_MODEL__FILE, IArchimatePackage.Literals.ARCHIMATE_MODEL__VERSION);

    public void doImport(File importedFile, IArchimateModel targetModel) throws IOException, ImportException {
        this.doImport(this.loadModel(importedFile), targetModel);
    }

    public void doImport(IArchimateModel importedModel, IArchimateModel targetModel) throws IOException, ImportException {
        this.importedModel = importedModel;
        this.targetModel = targetModel;
        CommandStack stack = (CommandStack)targetModel.getAdapter(CommandStack.class);
        stack.execute(this.getCommand());
    }

    public Command getCommand(File importedFile, IArchimateModel targetModel) throws IOException, ImportException {
        return this.getCommand(this.loadModel(importedFile), targetModel);
    }

    public Command getCommand(IArchimateModel importedModel, IArchimateModel targetModel) throws IOException, ImportException {
        this.importedModel = importedModel;
        this.targetModel = targetModel;
        return this.getCommand();
    }

    private IArchimateModel loadModel(File importedFile) throws IOException {
        if (!importedFile.exists()) {
            throw new IOException(NLS.bind((String)Messages.ModelImporter_2, (Object)importedFile));
        }
        return IEditorModelManager.INSTANCE.load(importedFile);
    }

    private Command getCommand() throws IOException, ImportException {
        if (this.objectMatcher == null) {
            this.objectMatcher = new DefaultObjectMatcher(this.targetModel);
        }
        this.statusMessages = new ArrayList<StatusMessage>();
        this.compoundCommand = new NonNotifyingCompoundCommand(Messages.ModelImporter_1){

            public void execute() {
                super.execute();
                ModelImporter.this.dispose();
            }
        };
        if (this.updateAll) {
            this.updateObject((EObject)this.importedModel, (EObject)this.targetModel);
            this.logMessage(StatusMessage.StatusMessageLevel.INFO, Messages.ModelImporter_3, this.targetModel);
        }
        TreeIterator iter = this.importedModel.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof IFolder) {
                new FolderImporter(this).importFolder((IFolder)eObject);
                continue;
            }
            if (eObject instanceof IArchimateConcept) {
                new ConceptImporter(this).importConcept((IArchimateConcept)eObject);
                continue;
            }
            if (eObject instanceof IDiagramModel) {
                new ViewImporter(this).importView((IDiagramModel)eObject);
                continue;
            }
            if (!(eObject instanceof IProfile)) continue;
            new ProfileImporter(this).importProfile((IProfile)eObject);
        }
        if (this.compoundCommand.canExecute()) {
            this.addCommand((Command)new SetArchimateReconnectionCommand(this.targetModel));
        }
        return this.compoundCommand;
    }

    protected IArchimateModel getImportedModel() {
        return this.importedModel;
    }

    protected IArchimateModel getTargetModel() {
        return this.targetModel;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean shouldUpdate() {
        return this.update;
    }

    public void setObjectMatcher(IObjectMatcher objectMatcher) {
        this.objectMatcher = objectMatcher;
    }

    public void setUpdateAll(boolean updateAll) {
        this.updateAll = updateAll;
        if (updateAll) {
            this.update = true;
        }
    }

    public boolean shouldUpdateAll() {
        return this.updateAll;
    }

    public void setUpdateFolderStructure(boolean update) {
        this.updateFolderStructure = update;
    }

    public boolean shouldUpdateFolderStructure() {
        return this.updateFolderStructure;
    }

    public List<StatusMessage> getStatusMessages() {
        return this.statusMessages;
    }

    void addCommand(Command cmd) {
        if (cmd.canExecute()) {
            this.compoundCommand.add(cmd);
        }
    }

    <T extends EObject> T findObjectInTargetModel(T eObject) throws ImportException {
        EObject foundObject = this.objectMatcher.getMatchingObject(eObject);
        if (foundObject == null) {
            return null;
        }
        if (foundObject.eClass() != eObject.eClass()) {
            throw new ImportException("Found object with same id but different class: " + String.valueOf(eObject));
        }
        return (T)foundObject;
    }

    <T extends IArchimateModelObject> T cloneObject(T eObject) {
        IArchimateModelObject newObject;
        if (eObject instanceof ICloneable) {
            newObject = (IArchimateModelObject)((ICloneable)eObject).getCopy();
            if (newObject instanceof IProfiles) {
                ((IProfiles)newObject).getProfiles().clear();
            }
        } else {
            newObject = (IArchimateModelObject)EcoreUtil.create((EClass)eObject.eClass());
            this.updateObject((EObject)eObject, (EObject)newObject);
        }
        newObject.setId(eObject.getId());
        this.objectMatcher.add((EObject)newObject);
        return (T)newObject;
    }

    void updateObject(EObject importedObject, EObject targetObject) {
        this.updateEObjectFeatures(importedObject, targetObject);
        if (importedObject instanceof IProperties && targetObject instanceof IProperties) {
            this.addCommand(new UpdatePropertiesCommand((IProperties)importedObject, (IProperties)targetObject));
        }
        if (importedObject instanceof IFeatures && targetObject instanceof IFeatures) {
            this.addCommand(new UpdateFeaturesCommand((IFeatures)importedObject, (IFeatures)targetObject));
        }
    }

    void updateEObjectFeatures(EObject importedObject, EObject targetObject) {
        if (importedObject == null || targetObject == null) {
            return;
        }
        for (EStructuralFeature eStructuralFeature : importedObject.eClass().getEAllStructuralFeatures()) {
            if (!(eStructuralFeature instanceof EAttribute) || IGNORED_EATTRIBUTES.contains(eStructuralFeature) || !eStructuralFeature.isChangeable() || eStructuralFeature.isDerived() || ((EAttribute)eStructuralFeature).isID()) continue;
            this.addCommand((Command)new EObjectFeatureCommand(null, targetObject, eStructuralFeature, importedObject.eGet(eStructuralFeature)));
        }
    }

    void logMessage(StatusMessage.StatusMessageLevel level, String message, Object ... objs) {
        this.statusMessages.add(new StatusMessage(level, message, objs));
    }

    public void dispose() {
        this.importedModel = null;
        this.targetModel = null;
        this.compoundCommand = null;
        this.objectMatcher = null;
    }

    private class SetArchimateReconnectionCommand
    extends CompoundCommand {
        private IArchimateModel model;

        private SetArchimateReconnectionCommand(IArchimateModel model) {
            this.model = model;
            this.add(new Command(){});
        }

        public void execute() {
            TreeIterator iter = this.model.eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelArchimateConnection)) continue;
                this.addArchimateReconnectionCommand((IDiagramModelArchimateConnection)eObject);
            }
            super.execute();
        }

        public void dispose() {
            super.dispose();
            this.model = null;
        }

        private void addArchimateReconnectionCommand(final IDiagramModelArchimateConnection connection) {
            IDiagramModelArchimateComponent matchingComponent;
            List list;
            IArchimateRelationship relationship = connection.getArchimateRelationship();
            if (((IDiagramModelArchimateComponent)connection.getSource()).getArchimateConcept() != relationship.getSource()) {
                list = DiagramModelUtils.findDiagramModelComponentsForArchimateConcept((IDiagramModel)connection.getDiagramModel(), (IArchimateConcept)relationship.getSource());
                if (!list.isEmpty()) {
                    matchingComponent = (IDiagramModelArchimateComponent)list.get(0);
                    final IConnectable oldSource = connection.getSource();
                    this.add(new Command(){

                        public void execute() {
                            connection.connect((IConnectable)matchingComponent, connection.getTarget());
                        }

                        public void undo() {
                            connection.connect(oldSource, connection.getTarget());
                        }
                    });
                    ModelImporter.this.logMessage(StatusMessage.StatusMessageLevel.WARNING, Messages.ModelImporter_4, connection, connection.getDiagramModel());
                } else {
                    this.add(DiagramCommandFactory.createDeleteDiagramConnectionCommand((IDiagramModelConnection)connection));
                    ModelImporter.this.logMessage(StatusMessage.StatusMessageLevel.WARNING, Messages.ModelImporter_5, connection, connection.getDiagramModel());
                }
            }
            if (((IDiagramModelArchimateComponent)connection.getTarget()).getArchimateConcept() != relationship.getTarget()) {
                list = DiagramModelUtils.findDiagramModelComponentsForArchimateConcept((IDiagramModel)connection.getDiagramModel(), (IArchimateConcept)relationship.getTarget());
                if (!list.isEmpty()) {
                    matchingComponent = (IDiagramModelArchimateComponent)list.get(0);
                    final IConnectable oldTarget = connection.getTarget();
                    this.add(new Command(){

                        public void execute() {
                            connection.connect(connection.getSource(), (IConnectable)matchingComponent);
                        }

                        public void undo() {
                            connection.connect(connection.getSource(), oldTarget);
                        }
                    });
                    ModelImporter.this.logMessage(StatusMessage.StatusMessageLevel.WARNING, Messages.ModelImporter_6, connection, connection.getDiagramModel());
                } else {
                    this.add(DiagramCommandFactory.createDeleteDiagramConnectionCommand((IDiagramModelConnection)connection));
                    ModelImporter.this.logMessage(StatusMessage.StatusMessageLevel.WARNING, Messages.ModelImporter_5, connection, connection.getDiagramModel());
                }
            }
        }
    }

    private static class UnduplicateProfileNamesCommand
    extends CompoundCommand {
        private IArchimateModel targetModel;

        private UnduplicateProfileNamesCommand(IArchimateModel targetModel) {
            this.targetModel = targetModel;
            this.add(new Command(){});
        }

        public void execute() {
            for (IProfile profile : this.targetModel.getProfiles()) {
                IProfile p = ArchimateModelUtils.getProfileByNameAndType((IArchimateModel)this.targetModel, (String)profile.getName(), (String)profile.getConceptType());
                if (p == null || p == profile) continue;
                this.add((Command)new EObjectFeatureCommand(null, (EObject)profile, (EStructuralFeature)IArchimatePackage.Literals.NAMEABLE__NAME, (Object)(profile.getName() + "_1")));
            }
            super.execute();
        }

        public void dispose() {
            super.dispose();
            this.targetModel = null;
        }
    }

    private static class UpdateFeaturesCommand
    extends Command {
        private IFeatures importedObject;
        private IFeatures targetObject;
        private ArrayList<IFeature> oldFeatures;

        private UpdateFeaturesCommand(IFeatures importedObject, IFeatures targetObject) {
            this.importedObject = importedObject;
            this.targetObject = targetObject;
            this.oldFeatures = new ArrayList(targetObject.getFeatures());
        }

        public void execute() {
            this.targetObject.getFeatures().clear();
            this.targetObject.getFeatures().addAll(EcoreUtil.copyAll((Collection)this.importedObject.getFeatures()));
        }

        public void undo() {
            this.targetObject.getFeatures().clear();
            this.targetObject.getFeatures().addAll(this.oldFeatures);
        }

        public boolean canExecute() {
            return !EcoreUtil.equals((List)this.importedObject.getFeatures(), this.oldFeatures);
        }

        public void dispose() {
            this.importedObject = null;
            this.targetObject = null;
            this.oldFeatures = null;
        }
    }

    private static class UpdatePropertiesCommand
    extends Command {
        private IProperties importedObject;
        private IProperties targetObject;
        private List<IProperty> oldProperties;

        private UpdatePropertiesCommand(IProperties importedObject, IProperties targetObject) {
            this.importedObject = importedObject;
            this.targetObject = targetObject;
            this.oldProperties = new ArrayList<IProperty>((Collection<IProperty>)targetObject.getProperties());
        }

        public void execute() {
            this.targetObject.getProperties().clear();
            this.targetObject.getProperties().addAll(EcoreUtil.copyAll((Collection)this.importedObject.getProperties()));
        }

        public void undo() {
            this.targetObject.getProperties().clear();
            this.targetObject.getProperties().addAll(this.oldProperties);
        }

        public boolean canExecute() {
            return !EcoreUtil.equals((List)this.importedObject.getProperties(), this.oldProperties);
        }

        public void dispose() {
            this.importedObject = null;
            this.targetObject = null;
            this.oldProperties = null;
        }
    }
}

